<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;


class CilReportExport implements FromCollection, WithEvents
{
    protected $data;

    public function __construct(array $data)
    {
        $this->data = $data;
    }

    public function collection()
    {
        return collect($this->data);
    }

    public function headings(): array
    {
        return [
            'Status_Name',
            'Count',
            'Type',
            'Total_Lead',
            '%'
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $worksheet = $event->sheet->getDelegate();
                $data = $worksheet->toArray();
                $rowCount = count($data);

                $previousType = null;
                $startRow = 0;

                for ($row = $startRow + 1; $row <= $rowCount; $row++) {
                    $currentType = $worksheet->getCell('C' . $row)->getValue();

                    if ($currentType !== $previousType) {
                        if ($row > $startRow + 1) {
                            // Merge cells from the previous row to the current row
                            $worksheet->mergeCells("C" . ($startRow) . ":C" . ($row - 1));
                        }
                        $startRow = $row;
                    }
                    $previousType = $currentType;
                }

                // Merge the remaining cells after the last type
                $worksheet->mergeCells("C" . ($startRow) . ":C" . ($rowCount));

                ///////////////////////////////////////////////////////////////

                $worksheet_Type_Count = $event->sheet->getDelegate();
                $dataType_Count = $worksheet_Type_Count->toArray();
                $rowCountType_Count = count($dataType_Count);
                $previousType_Type_Count = null; 

                
                $startRowType_Count = 0;

                for ($row = $startRowType_Count + 1; $row <= $rowCountType_Count; $row++) {
                    $currentType = $worksheet_Type_Count->getCell('D' . $row)->getValue();

                    if ($currentType !== $previousType_Type_Count) {
                        if ($row > $startRowType_Count + 1) {
                            // Merge cells from the previous row to the current row
                            $worksheet_Type_Count->mergeCells("D" . ($startRowType_Count) . ":D" . ($row - 1));
                        }
                        $startRowType_Count = $row;
                    }
                    $previousType_Type_Count = $currentType;
                }

                // Merge the remaining cells after the last type
                $worksheet_Type_Count->mergeCells("D" . ($startRowType_Count) . ":D" . ($rowCountType_Count));

                ///////////////////////////////////////////////////////////////

                $worksheet_Type_Percentage = $event->sheet->getDelegate();
                $dataType_Percentage = $worksheet_Type_Percentage->toArray();
                $rowCountType_Percentage = count($dataType_Percentage);
                $previousType_Type_Percentage = null;
                $startRowType_Percentage = 0;

                for ($row = $startRowType_Percentage + 1; $row <= $rowCountType_Percentage; $row++) {
                    $currentType = $worksheet_Type_Percentage->getCell('E' . $row)->getValue();

                    if ($currentType !== $previousType_Type_Percentage) {
                        if ($row > $startRowType_Percentage + 1) {
                            // Merge cells from the previous row to the current row
                            $worksheet_Type_Percentage->mergeCells("E" . ($startRowType_Percentage) . ":E" . ($row - 1));
                        }
                        $startRowType_Percentage = $row;
                    }
                    $previousType_Type_Percentage = $currentType;
                }

                // Merge the remaining cells after the last type
                $worksheet_Type_Percentage->mergeCells("E" . ($startRowType_Percentage) . ":E" . ($rowCountType_Percentage));
            },
        ];
    }
}
