<?php

namespace App\Helpers;

use App\Models\Lead;
use App\Models\Role;
use App\Models\User;
use App\Models\Setting;
use App\Models\LeadUser;
use Illuminate\Support\Facades\Log;

class LeadHelper
{
    public static function autoDistributeLead(Lead $lead): void
    {
        $salesRoleId = Role::where('name', 'Sales')->value('id');

        $user = User::where('role_id', $salesRoleId)
            ->inRandomOrder()
            ->first();

        if (!$user) {
            Log::warning("No Sales user found to assign lead ID {$lead->id}");
            return;
        }

        $lead->user_id = $user->id;
        $lead->status_id = 1;
        $lead->is_delay = 0;
        $lead->save();

        $extraTime = Setting::where('key', 'ExtraTime')->first()?->value ?? 12;
        $deadline = now()->addHours($extraTime);

        LeadUser::create([
            'user_id' => $user->id,
            'lead_id' => $lead->id,
            'status' => 'pending',
            'extraTime' => $extraTime,
            'deadline' => $deadline,
        ]);

        activity()
            ->performedOn($lead)
            ->causedBy(auth()->user() ?? $user)
            ->event('Auto Assigned Lead')
            ->withProperties([
                'lead_id' => $lead->id,
                'assigned_to' => $user->name,
            ])
            ->log("Lead auto-assigned to user: {$user->name}");
    }
}
