<?php

namespace App\Http\Controllers\API\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\{Mail, Hash};
use App\Models\{Client, Lead};
use Illuminate\Http\Request;
use App\Helpers\JsonResponse;
use App\Http\Requests\API\Auth\Guest\{GuestRequest,ForgetPasswordGuestRequest,
    SendOtpForgetPasswordRequest,ChangePasswordRequest, LoginRequest};
use App\Http\Resources\API\Auth\GuestResource;
use Illuminate\Support\Facades\Auth;
use App\Mail\SendEmailTest;


class GuestController extends Controller
{
    public function register(GuestRequest $request)
    {
     
        try {
            $data_lead = [
                'name' => $request->name,
                'email' => $request->email,
                'mobile_number' => $request->mobile_number,
                'job_title' => $request->job_title,
                'familly_number'=>$request->familly_number,
                'status' => 'new',
            ];
            $lead = Lead::create($data_lead);
            $data_client = [
                'name' => $lead->name,
                'email' => $lead->email,
                'phone_number' => $lead->mobile_number,
                'current_job' => $lead->job_title,
                'familly_number'=>$lead->familly_number,
                'password' => Hash::make($request->password),
                'social_status' => $request->social_status,
                'age' => $request->age,
                'address' => $request->address,
                'lead_id' => $lead->id,
            ];
            $client = Client::create($data_client);
            $token = $client->createToken('authToken')->accessToken;
            return JsonResponse::respondSuccess(token: $token, message: 'Created', data: new GuestResource($client));
        } catch (\Exception $e) {
            return JsonResponse::respondError($e->getMessage());
        }
    }

    public function login(LoginRequest $request)
    {
        try {
            if ($request->type == 'guest') {
                $client = Client::firstWhere(['email' => $request->email, 'type' => $request->type]);
                if ($client) {
                    if (Hash::check($request->password, $client->password)) {
                        $token = $client->createToken('authToken')->accessToken;
                        return JsonResponse::respondSuccess(token: $token, message: 'User login successfully.');
                    } else {
                        return JsonResponse::respondSuccess(message: 'Password mismatch', status: 422);
                    }
                } else {
                    return JsonResponse::respondSuccess(message: 'User does not exist', status: 422);
                }
            }
        } catch (\Exception $e) {
            return JsonResponse::respondError($e->getMessage());
        }
    }

    public function forgetPassword(ForgetPasswordGuestRequest $request)
    {
        
        try {
            if ($request->type == "guest") {
                $client = Client::where('email', $request->email)->first();
                if ($client) {
                    $otp = rand(1, 9999);
                    $client->update(['otp' => $otp]);
                    Mail::to($client->email)
                        ->send(new SendEmailTest("Please Use this Code To Rest Your Password : " . $otp));
                    return JsonResponse::respondSuccess(message: 'Reset link sent to your email.');
                } else {
                    return JsonResponse::respondSuccess(message: 'invalid email');
                }
            }
        } catch (\Exception $e) {
            return JsonResponse::respondError($e->getMessage());
        }
    }

    public function send_otp_forgetPassword(SendOtpForgetPasswordRequest $request)
    {
        try {
            $client = Client::where('otp', $request->otp)->first();
            if ($client) {
                return JsonResponse::respondSuccess(message: 'Successful');
            } else {
                return JsonResponse::respondSuccess(message: 'invalid Otp');
            }
        } catch (\Exception $e) {
            return JsonResponse::respondError($e->getMessage());
        }
    }

    public function change_password(ChangePasswordRequest $request)
    {
        try {
            $otp = Client::where('otp', $request->otp)->first();
            if ($otp) {
                $client = Client::findOrFail($otp->id);
                $client->password = Hash::make($request->password);
                $client->update();
                return JsonResponse::respondSuccess(message: 'Password Changed Successfully');
            }
        } catch (\Exception $e) {
            return JsonResponse::respondError($e->getMessage());
        }
    }

    public function logout()
    {
        Auth::guard('client')->user()->token()->revoke();
        return JsonResponse::respondSuccess(message: 'logout_success');
    }
}
