<?php

namespace App\Http\Controllers\API\Home;
use App\Http\Controllers\Controller;

use App\Models\Home;
use Illuminate\Http\Request;
use App\Helpers\JsonResponse;
use App\Http\Resources\CategoryResource;
use App\Http\Resources\NewsResource;
use App\Http\Resources\SettingLogoResource;
use App\Models\Category;
use App\Models\News;
use App\Models\Setting;

class HomeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try {
           $all_news=News::get();
           $all_category=Category::get();
           $setting_logo=Setting::where('key','logo')->get();
           return JsonResponse::respondSuccess(message:'Created',data:['category'=>CategoryResource::collection($all_category),'news'=>NewsResource::collection($all_news),'home_logo'=>SettingLogoResource::collection($setting_logo)]);
            } catch (\Exception $e) {
                return JsonResponse::respondError($e->getMessage());
            }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Home  $home
     * @return \Illuminate\Http\Response
     */
    public function show(Home $home)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Home  $home
     * @return \Illuminate\Http\Response
     */
    public function edit(Home $home)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Home  $home
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Home $home)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Home  $home
     * @return \Illuminate\Http\Response
     */
    public function destroy(Home $home)
    {
        //
    }
}
