<?php

namespace App\Http\Controllers\API\Profile;
use App\Http\Controllers\Controller;
use App\Models\{Client,Lead};
use App\Helpers\JsonResponse;
use App\Http\Requests\API\Profile\ProfileGuestRequest;
use App\Http\Resources\API\Profile\ProfileGuestResource;
use Illuminate\Support\Facades\Hash;

class ProfileGuestController extends Controller
{

    public function show($id){
        try {
            $client=Client::find($id);
            return JsonResponse::respondSuccess(message: 'Show', data: new ProfileGuestResource($client));
        } catch (\Exception $e) {
            return JsonResponse::respondError($e->getMessage());
        }
    }

    public function update(ProfileGuestRequest $request,$id)
    {
        try {
            $data = $request->validated();
            $client=Client::findOrFail($id);
            $data_client=[
                'name'=>$request->name,
                'email'=>$request->email,
                'phone_number'=>$request->mobile_number,
                'current_job'=>$request->job_title,
                'password'=>Hash::make($request->password),
                'social_status'=>$request->social_status,
                'familly_number'=>$request->familly_number,
                'age'=>$request->age,
                'address'=>$request->address
           ];
           $client->addMediaFromRequest('image')->toMediaCollection('image');
           $client->update($data_client);
           
            
            $lead=Lead::where('id',$client->lead_id);
            $data_lead=[
                'name'=>$client->name,
                'email'=>$client->email,
                'mobile_number'=>$client->phone_number,
                'job_title'=>$client->current_job,
                'familly_number'=>$client->familly_number,
                
           ];
           $lead->update($data_lead);
            return JsonResponse::respondSuccess( message:'Updated successfully.');
        
        } catch (\Exception $e) {
            return JsonResponse::respondError($e->getMessage());
        }
    }
}