<?php

namespace App\Http\Controllers\API\Profile;
use App\Http\Controllers\Controller;
use App\Models\{Client,Lead};
use App\Helpers\JsonResponse;
use App\Http\Requests\API\Profile\ProfileMemberRequest;
use App\Http\Resources\API\Profile\ProfileMemberResource;
use Illuminate\Support\Facades\Hash;

class ProfileMemberController extends Controller
{

    public function show($id){
        try {
            $client=Client::find($id);
            return JsonResponse::respondSuccess(message: 'Show', data: new ProfileMemberResource($client));
        } catch (\Exception $e) {
            return JsonResponse::respondError($e->getMessage());
        }
    }

    public function update(ProfileMemberRequest $request,$id)
    {
        try {
            $data = $request->validated();
            $client=Client::findOrFail($id);
            $data_client=[
                'password'=>Hash::make($request->password),
           ];
           $client->update($data_client);
            return JsonResponse::respondSuccess( message:'Updated successfully.');
        } catch (\Exception $e) {
            return JsonResponse::respondError($e->getMessage());
        }
    }
}