<?php

namespace App\Http\Controllers;

use App\Models\Lead;
use App\Models\User;
use App\Models\Action;
use App\Models\Client;
use App\Models\Ticket;
use App\Models\TicketType;
use App\Exports\ActionsExport;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;

class ActionController extends Controller
{

    public function index(Request $request)
    {
        if(auth()->user()->type == 'admin' || auth()->user()->role->name == 'Customer Service Manager')
        {
            $actions = Action::query();
        }
        // Actions Tree
        else{
            $actions = Action::query();
            
            $users = User::all();
            $CurrentUser = auth()->user();
            $UserChildren = array();

            foreach ($users as $userr) {
                $parents = $userr->getParents()->pluck('id')->toArray();
                if (in_array($CurrentUser->id, $parents)) {
                    array_push($UserChildren, [
                        'id' => $userr->id,
                        'name' => $userr->name,
                    ]);
                }
            }

            $ActionBulk = array();
            if ($CurrentUser->ticket_actions()->count() != 0) {
                foreach ($CurrentUser->ticket_actions as $action) {
                    array_push($ActionBulk, $action->id);
                }
            }
            for ($i = 0; $i < count($UserChildren); $i++) {
                $user = User::find($UserChildren[$i]['id']);
                if (count($user->ticket_actions) == 0) {
                    continue;
                } else {
                    foreach ($user->ticket_actions as $action) {
                        array_push($ActionBulk, $action->id);
                    }
                }
            }
           
            $actions->whereIn('id', $ActionBulk);
        }
        $ticketTypes = DB::table('ticket_types')->select('id', 'name')->get();
        $units = DB::table('units')->select('id', 'name')->where('status', '!=' , 'free')->get();
        $methods = DB::table('methods')->select('id', 'name')->get();
        $users = DB::table('users')->select('id', 'name')->get();
        $clients = DB::table('clients')->select('id', 'name')->get();

// filter
        
        if ($request->client_id) {
            $actions->whereIn('client_id', $request->client_id);
        }

        if ($request->unit_id) {
            $actions->whereIn('unit_id', $request->unit_id);
        }

        if ($request->ticket_type_id) {
            $actions->whereIn('ticket_type_id', $request->ticket_type_id);
        }

        if ($request->user_id) {
            $actions->whereIn('user_id', $request->user_id);
        }

        if ($request->action_creation1 && $request->action_creation2) {
            $actions->whereDate('created_at', '>=', $request->action_creation1)
                ->whereDate('created_at', '<=', $request->action_creation2);
        }

        if ($request->ticket_creation1 && $request->ticket_creation2) {
            $tickets = Ticket::whereDate('created_at', '>=', $request->ticket_creation1)
            ->whereDate('created_at', '<=', $request->ticket_creation2)->pluck('id')->toArray();
            
            $actions->whereIn('ticket_id', $tickets);
        }

        if ($request->ticket_creation1 && $request->ticket_creation2) {
            $tickets = Ticket::whereDate('created_at', '>=', $request->ticket_creation1)
            ->whereDate('created_at', '<=', $request->ticket_creation2)->pluck('id')->toArray();
            $actions->whereIn('ticket_id', $tickets);
        }

        if ($request->ticketType_id) {
            $tickets = Ticket::where('ticket_type_id',$request->ticketType_id)->pluck('id')->toArray();
            $actions->whereIn('ticket_id', $tickets);
        }

        if ($request->ticket_status) {
            $tickets = Ticket::where('status',$request->ticket_status)->pluck('id')->toArray();
            $actions->whereIn('ticket_id', $tickets);
        }

// end filter
        $actions = $actions->paginate(50)->withQueryString();

        return view('tickets.TicketActions', compact('actions','units','methods' ,'ticketTypes', 'users', 'clients'));
    }

    /**
     * Export actions to Excel
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Symfony\Component\HttpFoundation\BinaryFileResponse
     */
    public function export(Request $request)
    {
        $user = auth()->user();
        activity()
            ->event('export')
            ->log($user->name . ' exported actions data');

        return Excel::download(new ActionsExport($request), 'actions_' . date('Y-m-d_H-i-s') . '.xlsx');
    }
}