<?php

namespace App\Http\Controllers\Administration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\TeamRequest;
use App\Models\Team;
use Illuminate\Support\Facades\DB;
use Exception;

class TeamController extends Controller
{
    // public function __construct()
    // {
    //     $this->middleware('permission:teams-create');
    //     $this->middleware('permission:teams-read');
    //     $this->middleware('permission:teams-update');
    //     $this->middleware('permission:teams-delete');
    // }

    public function index()
    {
        $teams = Team::get();
        return view('teams.index',compact('teams'));
    }

    public function create()
    {
        return view('teams.create');
    }

    public function store(TeamRequest $request)
    {
        try
        {
            DB::beginTransaction();
            $team = new Team();
            $team->name = $request->name;
            $team->display_name = ucwords($request->name);
            $team->description = $request->description;
            $team->save();
            DB::commit();

            return redirect()->route('index.teams')->with('success','Team Created Successfully');
        }
        catch(Exception $e){
            return redirect()->back()->with('error',$e->getMessage());
        }
    }

    public function edit($teamId)
    {
        $team = Team::findOrFail($teamId);
        return view('teams.edit',compact('team'));
    }

    public function update(TeamRequest $request,$teamId)
    {
        $team = Team::findOrFail($teamId);
        try
        {
            DB::beginTransaction();
            $team->name = $request->name;
            $team->display_name = ucwords($request->name);
            $team->description = $request->description;
            $team->save();
            DB::commit();

            return redirect()->route('index.teams')->with('success','Team Updated Successfully');
        }
        catch(Exception $e){
            return redirect()->back()->with('error',$e->getMessage());
        }
    }

    public function show($teamId)
    {
        $team = Team::findOrFail($teamId);
        return view('teams.show',compact('team'));
    }

    public function destroy($teamId)
    {
        $team = Team::findOrFail($teamId);
        $team->delete();
        return redirect()->route('index.teams')->with('success','Team Deleted Successfully');
    }
}
