<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\CallAction;

class CallActionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $callActions = CallAction::get();
        return view('callActions.create', compact('callActions'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $callActions = CallAction::pluck('name');
    
        $fCount = count($callActions);
        $rCount = count($request->name);
            if($rCount >= $fCount){ 
                for ($i=0; $i<$rCount; $i++) {
                    CallAction::updateOrCreate(
                        [
                            'name' => $request->name[$i],
                        ],
                        [
                            'type' => $request->type[$i],
                        ],
                    );
                }
            }
             $user = auth()->user();
             activity()
             ->event('update CallActions')
             ->log($user->name .' updated call Actions');
            return redirect()->back()->with('success', 'Call Actions updated Successfully');        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(CallAction $callAction)
    {
        //
        $callAction->delete();
        return redirect()->back()->with('success', 'Call Action Trashed Successfully');

    }
}
