<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Notifications;

class NotificationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        // $assignUser = Notification::find(1);
        $notifications = Notifications::get();
        
        $user = auth()->user();
        activity()
        ->event('visit')
        ->log($user->name .' Visited Notifications page');

        return view('notifications.index', compact('notifications'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $user = auth()->user();
 
    foreach($request->notification as $notification)
    {
        $noti = Notifications::where('id' , $notification['id'])->first();
        if(isset($notification['isActive']))
        {
            $noti->is_active = $notification['isActive'];
                activity()
                ->event('visit')
                ->log($user->name .' activated notification');
        }
        else
        {
            $noti->is_active = 0;
            
            activity()
            ->event('visit')
            ->log($user->name .' de-activated notification');
        }
        $noti->save();
    }
        return redirect()->route('dashboard')->with('success', 'Notifications Settings Updated Successfully');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}