<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Transaction;
use App\Models\Payment;
use App\Http\Requests\TransactionRequest;
use Illuminate\Support\Facades\DB;

class TransactionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('transactions.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(TransactionRequest $request)
    {
        //
        $payment = Payment::find($request->payment_id);

        $subtract = $payment->total_amount - $payment->total_paid;

        if($subtract != 0 && $subtract >= $request->amount){
            // Save and calculate the subtraction
            Transaction::create($request->all());
            $total_paid = $payment->total_paid + $request->amount;
            
            $payment->total_paid = $total_paid;
            $payment->status ='inProgress';
            $payment->save();
            dd('transaction saved');
            
        }elseif($subtract != 0 && $subtract < $request->amount){
            $transaction = new Transaction;
            $transaction->payment_id = $request->payment_id;
            $transaction->amount = $subtract;
            $transaction->save();

            $extra = $request->amount - $subtract;
            $payment->total_paid = $payment->total_amount;
            $payment->status = 'paid';
            $payment->save();
            dd('you have an extra amount:'.$extra);

        }else{
            dd('payment is already paid');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(TransactionRequest $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
