<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\UnitSetting;
use App\Models\Setting;

class UnitSettingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        // $this->middleware('permission:settings-read',['only' => ['index']]);
    }
    
    public function index()
    {
        //
        $user = auth()->user();
        activity()
                ->event('visit')
                ->log($user->name .'viewed Setting page');
        $ExtraTime = Setting::where('key', 'ExtraTime')->first();
        
        return view('unitSettings.index', compact('ExtraTime'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $residentials = UnitSetting::where('type', 'residential')->get();
        
        $medicals = UnitSetting::where('type', 'medical')->get();

        $commercials = UnitSetting::where('type', 'commercial')->get();

        $administratives = UnitSetting::where('type', 'administrative')->get();
        
        $finishings = UnitSetting::where('type', 'finishing')->get();
        
        $views = UnitSetting::where('type', 'view')->get();
        
        $unit_codes = UnitSetting::get();
        $user = auth()->user();
        activity()
                ->event('visit')
                ->log($user->name .' viewed unit inventory settings page');
        return view('unitSettings.create', compact('residentials','commercials', 'administratives' , 'finishings' , 'views', 'unit_codes','medicals'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|unique:unit_settings',
        ]);

        $count = count($request->name);

        for ($i = 0; $i<$count; $i++) {
                UnitSetting::create(
                    [
                        'name' => $request->name[$i],
                        'type' => $request->type[$i]
                    ]
                );
        }
           
         $user = auth()->user();
         activity()
         ->event('update')
         ->log($user->name .' updated unit inventory settings');

            return redirect()->back()->with('success', 'Unit settings updated Successfully');
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $setting = UnitSetting::find($id);
        // dd($setting);
        $setting->delete();

        return redirect()->back()->with('success', 'Unit settings trashed Successfully');

    }

    public function SetExtraTime(Request $request)
    {
        //
        $ExtraTime = Setting::where('key', 'ExtraTime')->first();
        $ExtraTime->value = $request->ExtraTime;
        $ExtraTime->save();
        $user = auth()->user();
        activity()
        ->event('update')
        ->log($user->name .' changed extra time value');

        return redirect()->back()->with('success', 'Extra Time Updated Successfully');

    }
}