<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class Language
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        $locale = ($request->hasHeader('X-localization')) ? $request->header('X-localization') : 'ar';

        app()->setLocale($locale);
        $response = $next($request);
        $response->headers->set('X-localization', $locale);
        return $response;
    }
}
