<?php

namespace App\Http\Requests\API\Profile;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class ProfileGuestRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
       
        return [
            'name' => 'required|min:3',
            'email' => ['required','email',Rule::unique('clients')->ignore($this->id)],
            'address' => 'required',
            'mobile_number' => ['required',Rule::unique('leads')->ignore($this->id)],
            'age' => 'required',
            'job_title' => 'required',
            'social_status' => 'required|in:0,1',
        ];
    }
}
