<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ClientRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'unit_id' => ['nullable'],
            'civil_date' => ['nullable'],
            'civil_city' => ['required'],
            'civil_number' => ['required'],
            'civil_address' => ['required'],
            'mobile_number.*' => ['unique:phone_numbers,phone'],
        ];
    }
}
