<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class EventRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        if (Request::route()->getName() == 'calendar.create')
        {
            return [
                'title' => 'required',
                'start' => 'required',
                'end' => 'required'
            ];
        }
        if (Request::route()->getName() == 'calendar.edit')
        {
            $id = $request->id;
            return [
                'id' => 'required',
                'title' => 'required',
                'start' => 'required',
                'end' => 'required'
            ];
        }

    }
}
