<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class LeadRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        if (Request::route()->getName() == 'leads.store')
        {
            return [
                'name' => ['nullable', 'string', 'between:2,100'],
                'email' => ['nullable', 'unique:leads,email', 'email'],
                'job_title' => ['nullable'],
                // 'user_id' => ['required'],
                'mobile_number.*' => ['unique:phone_numbers,phone'],
            ];
        }

        if (Request::route()->getName() == 'leads.update')
        {
            $id = $request->id;
            return [
                'name' => ['nullable', 'string', 'between:2,100'],
                'email' => ['nullable'],
                'job_title' => ['nullable'],
                // 'user_id' => ['required'],
                // 'mobile_number.*' => ['unique:phone_numbers,phone'],
                
                // 'status' => ['required', 'in:new,in-process,converted,dead,interestad,not_interested,wait,follow_up,recycled'],
            ];
        }

    }
}
