<?php

namespace App\Imports;

use App\Models\Broker;
use App\Models\User;
use App\Models\Country;
use App\Models\PhoneNumber;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Concerns\SkipsEmptyRows;
class BrokerImport implements ToModel,WithHeadingRow,WithValidation,SkipsEmptyRows
{
    use Importable,SkipsFailures;
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        //$assignedUser = User::whereName($row['assigned_user'])->first();
        $broker = Broker::create([
            'name' => $row['name'],
            'email' => $row['email'],
            'type' => $row['type'],
            'description' => $row['description'],
            'user_id' => $row['salesman'],
            'address' => $row['address'],
        ]);
        $country = Country::Where('phonecode',$row['country_code'])->first();

        $phone = PhoneNumber::create([
            'phone' => $row['mobile_number'],
            'broker_id' => $broker->id,
            'country_id' => $country->id,
        ]);
        
         if($row['mobile_number2'] != null){
            $country2 = Country::Where('phonecode',$row['country_code2'])->first();

            $phone2 = PhoneNumber::create([
                'phone' => $row['mobile_number2'],
                'broker_id' => $broker->id,
                'country_id' => $country2->id,
            ]);
        }
        return $broker;
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string'],
            'email' => ['nullable', 'unique:clients,email', 'email'],
            'country_code' => ['required'],
            'mobile_number' => ['required','unique:phone_numbers,phone'],
        ];
    }
    
     public function onFailure(\Maatwebsite\Excel\Validators\Failure ...$failures)
    {
        $data = [];
        foreach ($failures as $failure) {

            array_push($data,$failure->errors());
        }

        Session::push('LeadsErrors', collect($data));
    }

    public function customValidationMessages()
    {
        return [
            'mobile_number.unique' => 'This mobile number :input is duplicated.',
            'mobile_number2.unique' => 'This mobile number :input is duplicated.',
        ];
    }
}
