<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Schema;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Laravel\Passport\HasApiTokens;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;


class Broker extends  Authenticatable implements HasMedia
{
    use HasFactory;
    use SoftDeletes;
    use LogsActivity;

    use HasApiTokens;
    use InteractsWithMedia;

    public $guarded = [];

    public function phone_numbers()
    {
        return $this->hasMany(PhoneNumber::class);
    } 

    public function files()
    {
        return $this->hasMany(File::class);
    }

    public function leads()
    {
        return $this->hasMany(Lead::class);
    } 
    public function inquiries()
    {
        return $this->hasMany(Inquiry::class);
    }
    public function communications()
    {
        return $this->hasMany(Communication::class);
    } 

    public function images()
    {
        return $this->hasMany(Gallery::class);
    } 

    public function salesMan()
    {
        return $this->belongsTo(User::class, 'user_id');
    } 

    public static function getTableColumns()
    {
        return Schema::getColumnListing((new self)->getTable());
    }

    public function agents()
    {
        return $this->belongsToMany(Agent::class, 'agent_broker');
    }

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logUnguarded()->logOnlyDirty()->setDescriptionForEvent(fn (string $eventName) => "This model has been {$eventName}")->useLogName('Broker Action');;
    }

}
