<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Builder;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class Lead extends Model
{
    use HasFactory;
    use SoftDeletes;
    use LogsActivity;

    protected $guarded = [];
    protected $table = 'leads';

    protected $dates = ['deleted_at'];

    public function created_by_user()
    {
        return $this->belongsTo(User::class , 'created_by');
    }

    public function LeadStatus()
    {
        return $this->belongsTo(Status::class, 'status_id');
    }

    public function user(){
        return $this->belongsTo(User::class , 'user_id');
    }


    public function communications()
    {
        return $this->hasMany(Communication::class);
    }

    public function campaign()
    {
        return $this->belongsTo(Campaign::class);
    }

    public function project()
    {
        return $this->belongsTo(Project::class, 'project_id');
    }

    public function source()
    {
        return $this->belongsTo(Source::class);
    }
    public function agent()
    {
        return $this->belongsTo(Agent::class);
    }
    public function phone_numbers()
    {
        return $this->hasMany(PhoneNumber::class);
    }

    public function streams()
    {
        return $this->hasMany(Stream::class);
    }

    protected static function boot() {
        parent::boot();
        static::addGlobalScope('order', function (Builder $builder) {
            $builder->orderBy('created_at', 'desc');
        });
    }

    public function client()
    {
        return $this->belongsTo(Client::class, 'client_id');
    }

    public function inquiry()
    {
        return $this->hasOne(Inquiry::class);
    }


    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()->logUnguarded()->logOnlyDirty()->setDescriptionForEvent(fn (string $eventName) => "This model has been {$eventName}")->useLogName('Lead history');
    }

    public static function getTableColumns()
    {
        return Schema::getColumnListing((new self)->getTable());
    }
}
