<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Phase extends Model
{
    use HasFactory;
    use SoftDeletes;

    public $guarded = [];

    public function project()
    {
        return $this->belongsTo(Project::class);
    } 

    public function users()
    {
        return $this->belongsToMany(User::class);
    } 

    public function buildings()
    {
        return $this->hasMany(Building::class);
    }
} 
