<?php

namespace App\Models;

use Laratrust\Models\LaratrustRole;
use Illuminate\Database\Eloquent\SoftDeletes;
class Role extends LaratrustRole
{
    use SoftDeletes;
    public $guarded = [];

    public function permissions()
    {
        return $this->belongsToMany(
            config('laratrust.models.permission'),
            config('laratrust.tables.permission_role'),
            'role_id',
            'permission_id'
        );
    }

    public function projects()
    {
        return $this->belongsToMany(Project::class);
    }

    public function users()
    {
        return $this->belongsToMany(User::class);
    }
    
    public function parent() 
    {
        return $this->hasOne(Role::class, 'id', 'role_id');
    }

    
    public function getParents()
    {
        $parents = collect([]);

        $parent = $this->parent;

        while(!is_null($parent)) {
            $parents->push($parent);
            $parent = $parent->parent;
        }

        return $parents;
    }

    public function childs() {
        return $this->hasMany(Role::class,'role_id','id');
    }


    

}
