<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\MediaLibrary\MediaCollections\Models\Media;

class Stream extends Model implements HasMedia
{
    use HasFactory;
    use InteractsWithMedia;

    protected $fillable = ['comment','lead_id','created_by'];

    protected $appends = [
        'files',
    ];

    public function lead()
    {
        return $this->belongsTo(Lead::class , 'lead_id');
    }

    public function client()
    {
        return $this->belongsTo(Client::class , 'client_id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class , 'created_by');
    }

    public function getFilesAttribute($value)
    {
        return $this->getMedia('files')->all();
    }
}
