<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
// use Spatie\Activitylog\Traits\LogsActivity;
// use Spatie\Activitylog\LogOptions;
class Ticket extends Model
{
    use HasFactory; 
    use SoftDeletes;
    // use LogsActivity;

    public $guarded = [];

    // public function getActivitylogOptions()
    // {
    //     return LogOptions::defaults()
    //     ->setDescriptionForEvent(fn(string $eventName) => "This model has been {$eventName}");
    // }

    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    public function users()
    {
        return $this->belongsToMany(User::class, 'ticket_user');
    }

    public function ticket_created_by()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function assigned_to()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function comments()
    {
        return $this->hasMany(Comment::class);
    }

    public function project()
    {
        return $this->belongsTo(Project::class);
    }
    
    public function unit()
    {
        return $this->belongsTo(Unit::class);
    }

    public function method()
    {
        return $this->belongsTo(Method::class);
    }

    public function ticket_type()
    {
        return $this->belongsTo(TicketType::class, 'ticket_type_id');
    }

    public function actions()
    {
        return $this->hasMany(Action::class);
    }

    public function files()
    {
        return $this->hasMany(File::class, 'ticket_id');
    }
    public function alerts()
    {
        return $this->hasMany(Alert::class);
    }
}
