<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('units', function (Blueprint $table) {
            $table->increments('id');
            $table->char('name');
            $table->char('floor');

            $table->char('unit_space');
            $table->char('unit_meter_price');
            $table->char('unit_total_price');

            $table->char('roof_meter_price')->nullable();
            $table->char('roof_total_price')->nullable();

            $table->char('garden_percentage')->nullable();
            $table->char('garden_space')->nullable();

            $table->char('garden_meter_price')->nullable();
            $table->char('garden_total_price')->nullable();

            $table->char('bedrooms')->nullable();
            $table->char('bathrooms')->nullable();
            $table->date('Booked_date');
            $table->boolean('is_active')->default(0);

            $table->unsignedBigInteger('user_id')->nullable();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->unsignedBigInteger('building_id')->nullable();
            $table->foreign('building_id')->references('id')->on('buildings')->onDelete('cascade');

            $table->char('type')->nullable();
            $table->char('finishing')->nullable();
            $table->char('view')->nullable();
            $table->enum('status',['free','hold', 'reserved','downpayment', 'taken'])->default('free');

            $table->softDeletes();


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('units');
    }
};
