<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payment_plan_details', function (Blueprint $table) {
            $table->id();
            $table->string('amount')->nullable();
            $table->string('batch')->nullable();
            $table->string('count')->nullable();

            $table->unsignedBigInteger('payment_plan_id')->nullable();
            $table->foreign('payment_plan_id')->references('id')->on('payment_plans');

            $table->unsignedBigInteger('payment_type_id')->nullable();
            $table->foreign('payment_type_id')->references('id')->on('payment_types');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_plan_details');
    }
};
