<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Code;

class CodeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        //
        $types = [
            [
                "code" => "-c_name-",
                "purpose" => "client name"
            ],
            [
                "code" => "-bs_segment_name-",
                "purpose" => "unit name Or unit Code"
            ],
            [
                "code" => "-c_day-",
                "purpose" => "contract day"
            ],
            [
                "code" => "-c_date-",
                "purpose" => "contract date"
            ],
            [
                "code" => "-civil_id_num_passport_num-",
                "purpose" => "client civil id"
            ],
            [
                "code" => "-civil_id_city-",
                "purpose" => " client civil id city"
            ],
            [
                "code" => "-civil_id_date-",
                "purpose" => "client civil id date"
            ],
            [
                "code" => "-civil_id_address-",
                "purpose" => "client civil id address"
            ],
            [
                "code" => "-customer_job-",
                "purpose" => "client job title"
            ],
            [
                "code" => "-phones-",
                "purpose" => "client phone numbers"
            ],
            [
                "code" => "-client_nationality-",
                "purpose" => "nationality"
            ],
            [
                "code" => "-email-",
                "purpose" => "client email"
            ],
            [
                "code" => "-bs_unit_space-",
                "purpose" => "unit space"
            ],
            [
                "code" => "-b_Building-",
                "purpose" => "building name"
            ],
            [
                "code" => "-phase-",
                "purpose" => "phase name"
            ],
            [
                "code" => "-units_Floor-",
                "purpose" => "unit floor"
            ],
            [
                "code" => "-bs_Garden_Space-",
                "purpose" => "garden space"
            ],
            [
                "code" => "-bs_Garden_Price-",
                "purpose" => "garden price"
            ],
            [
                "code" => "-bs_Roof_Price-",
                "purpose" => "roof price"
            ],
            [
                "code" => "-bs_Roof_Space-",
                "purpose" => "roof space"
            ],
            [
                "code" => "-garage_name-",
                "purpose" => "garage name"
            ],
            [
                "code" => "-garage_price-",
                "purpose" => "garage price into digits format"
            ],
            [
                "code" => "-garage_word-",
                "purpose" => "garage price into Arabic words format"
            ],
            [
                "code" => "-num_deal_price-",
                "purpose" => "price of unit in digits format"
            ],
            [
                "code" => "-word_deal_price-",
                "purpose" => "num-deal-price but in arabic words"
            ],
            
            [
                "code" => "-num_maintenance-",
                "purpose" => "Maintenance in digit format"
            ],
            [
                "code" => "-word_maintenance-",
                "purpose" => "Maintenance in arabic words"
            ],
            
            [
                "code" => "-num_amount-",
                "purpose" => "the 'num_deal_price' + '(facilities, garden and roof) in digits format"
            ],
            [
                "code" => "-word_amount-",
                "purpose" => "the 'num_deal_price' + '(facilities, garden and roof) in Arabic Words format"
            ],

            [
                "code" => "-num_downpayment-",
                "purpose" => "the down payment amount"
            ],
            [
                "code" => "-word_downpayment-",
                "purpose" => "the remaining amount in digits format"
            ],
            [
                "code" => "-num_remaining-",
                "purpose" => "the remaining amount in digits format"
            ],
            [
                "code" => "-word_remaining-",
                "purpose" => "the remaining amount in Arabic words format"
            ],
            
        ];
        foreach ($types as $key => $value) {
            Code::create($value);
        }
    }
}
