@extends ('../welcome')

@section('content')
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Phases</h3>
                <p>Total: {{ count($phases) }}</p>

                <a href="{{ route('phases.restoreAll') }}" title="Restore All" style="float:right">
                    <button class="btn btn-square btn-outline-success" type="button"><i
                            class="fas fa-trash-restore-alt"></i></button>
                </a>

            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Phase Name</th>
                            <th>Project Name</th>
                            <th>Created Date</th>
                            <th>Created Time</th>
                            <th>Restore</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($phases as $phase)
                            <?php $temp = explode(' ', $phase->created_at->setTimezone('Africa/Cairo')); ?>

                            @if (!empty($phase->project->id))
                                <tr>
                                    <td>{{ $phase->id }}</td>
                                    <td>
                                        <a href="{{ route('phases.show', $phase->id) }}">
                                            {{ $phase->name }}
                                        </a>
                                    </td>
                                    <td>
                                        <a href="{{ route('projects.show', $phase->project->id) }}">
                                            {{ $phase->project->name }}
                                        </a>
                                    </td>
                                    <td>{{ $temp[0] }}</td>
                                    <td>{{ $temp[1] }}</td>
                                    <td>
                                        <a class="btn btn-outline-light" title="Restore"
                                            href="{{ route('phasesRestore', $phase->id) }}">
                                            <i class="fas fa-trash-restore-alt"></i>
                                        </a>

                                    </td>

                                </tr>
                            @endif
                        @endforeach
                    </tbody>
                </table>
            </div>
            <!-- /.card-body -->
        </div>
    </div>
    <!-- /.row -->
@endsection
