@extends ('../welcome')


@section ('content')

<div class="card card-info col-6">

    <!-- /.card-header -->
    <div class="card-body">
        <form action="{{ route('agents.store') }}" method="post">
            @csrf

            <div class="form-group row">
                <label class="col-2">Name:</label>
                <input type="text" name="name" class="form-control col-6" placeholder="Name...">
            </div>
            <div class="form-group row">
                <label class="col-2">Email:</label>
                <input type="email" name="email" class="form-control col-6" placeholder="Ex: vutu@mailinator.com">
            </div>
            <div class="form-group row">
                <label class="col-2">Phone:</label>
                <input type="phone" name="phone" class="form-control col-6" placeholder="Ex: +2 000 0000 000">
            </div>
            
            

            <button type="submit" style="float:right" class="btn btn-info">Submit</button>
        </form>
    </div>
    <!-- /.card-body -->
</div>

    <script src="{{ asset('asset/plugins/jquery/jquery.min.js') }}"></script>
    <script>
        // Remove leading zeros from phone number input
        $(document).ready(function() {
            $('input[name="phone"]').on('input', function() {
                var phoneNumber = $(this).val();
                
                // Remove leading zeros but keep the value if it's just "0"
                if (phoneNumber.length > 1 && phoneNumber.startsWith('0')) {
                    $(this).val(phoneNumber.replace(/^0+/, ''));
                }
            });
            
            // Also handle on blur (when user leaves the field)
            $('input[name="phone"]').on('blur', function() {
                var phoneNumber = $(this).val();
                if (phoneNumber.length > 1 && phoneNumber.startsWith('0')) {
                    $(this).val(phoneNumber.replace(/^0+/, ''));
                }
            });
        });
    </script>
@endsection