@extends ('../welcome')

@section ('content')

<div class="card card-info">

    <!-- /.card-header -->
    <div class="card-body">
        <form action="{{ route('batches.update', $batch->id) }}" method="post">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="form-group col-7">
                    <label>unit</label>
                    <input type="text" class="form-control" value="{{$batch->unit->name ?? ''}}" readonly>
                    <input type="hidden" name="unitId" value="{{$batch->unit->id ?? ''}}">
                </div>
            </div>
            <div id="inputFormRow">
                <div class="row">
                    <div class="form-group col-2">
                        <label>Payment Type</label>
                        <select class="select2 custom-select form-control-border" name="title" required>
                            @foreach($paymentTypes as $type)
                            <option value="{{$type->name}}">{{$type->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-2">
                        <label>Type</label>
                        <select class="select2 custom-select form-control-border" name="type" required>
                            <option value="maintenance">Maintenance</option>
                            <option value="total_unit">Total Unit</option>
                        </select>
                    </div>
                    <div class="form-group col-1">
                        <label>Amount</label>
                        <input type="number" step="any" class="form-control" name="amount" value="{{$batch->amount}}"
                            required>
                    </div>
                    <div class="form-group col-2">
                        <label>Date</label>
                        <input type="date" class="form-control" name="date" value="{{$batch->date}}" required>
                    </div>
                </div>
            </div>

            <div class="card-footer">
                <button type="submit" class="btn btn-info">Submit</button>
            </div>
        </form>
    </div>
    <!-- /.card-body -->
</div>
@endsection