@extends ('../welcome')
<!-- namespace App; -->


@section ('content')
<style>
#phone:invalid:focus {
    border-color: red;
}
</style>
<div class="card">
    <form id="myForm" action="{{ route('brokers.update', $broker->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        <div class="card-body register-card-body mt-5 ml-4">
            <div class="row">
                <div class="col-6">
                    <div class="row">
                        <div class="form-group col-10">
                            <label>Name</label>
                            <input type="text" name="name" value="{{$broker->name ?? ''}}" class="form-control">
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group col-5">
                            <label for="address">Address</label>
                            <input type="text" id="address" class="form-control" value="{{$broker->address ?? ''}}"
                                name="address">
                        </div>
                        <div class="form-group col-5">
                            <label>Email</label>
                            <input type="email" class="form-control" value="{{$broker->email ?? ''}}" name="email">
                        </div>
                    </div>

                    <div class="row">
                        <div class="form-group col-5">
                            <label>Sales Man</label>
                            <select name="user_id" class="select2 custom-select form-control-border" id="salesMan">
                                @foreach ($users as $user)
                                <option value="{{$user->id}}" {{$broker->user_id == $user->id ? 'selected' : ''}}>{{$user->name}}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group col-5">
                            <label for="type">Type</label>
                            <select id="type" name="type" class="custom-select form-control-border" id="campaigns">
                                <option value="broker" {{$broker->type == 'broker' ? 'selected' : ''}}>Broker</option>
                                <option value="ambassador" {{$broker->type == 'ambassador' ? 'selected' : ''}}>Ambassador</option>
                            </select>
                        </div>

                        <div class="form-group col-5">
                            <label for="owner">Owner Name</label>
                            <input id="owner" type="text" class="form-control" name="owner_name" value="{{$broker->owner_name ?? ''}}">
                        </div>
                        <div class="form-group col-5">
                            <label for="sales_admin">Sales Admin</label>
                            <input id="sales_admin" type="text" class="form-control" name="sales_admin" value="{{$broker->sales_admin ?? ''}}">
                        </div>

                        <div class="form-group col-5">
                            <label for="authorized_name">Authorized Name</label>
                            <input id="authorized_name" type="text" class="form-control" name="authorized_name" value="{{$broker->authorized_name ?? ''}}">
                        </div>

                        <div class="form-group col-5">
                            <label for="commercial_record">Commercial Record</label>
                            <input id="commercial_record" type="text" class="form-control" name="commercial_record" value="{{$broker->commercial_record ?? ''}}">
                        </div>

                        <!-- textarea -->
                        <div class="form-group col-10">
                            <label for="desc">Description: </label>
                            <textarea id="desc" class="form-control" name="description"
                                placeholder="Description">{{$broker->description ?? ''}}</textarea>
                        </div>

                    </div>
                </div>
                <div class="col-6">
                    <div class="card">
                        <div class="card-header">
                            <div class="form-check col-10">
                                <input class="form-check-input" id="hasContract" name="has_contract" {{$broker->has_contract == 1 ? 'checked' : ''}} type="checkbox">
                                <label class="form-check-label" for="hasContract">has Contract ?</label>
                            </div>
                        </div>
                        <div class="row card-body" id="contractData" style="display:{{$broker->has_contract != 1 ? 'none' : ''}}">
                            <div class="form-group col-10">
                                <label for="commission">Commission %</label>
                                <input id="commission" max="100" type="number" step="any" class="form-control" value="{{$broker->commission ?? ''}}" name="commission">
                            </div>

                            <div class="form-group col-5">
                                <label for="contract_startDate">Start Date</label>
                                <input id="contract_startDate" type="date" class="form-control"
                                    name="contract_startDate" value="{{$broker->contract_startDate ?? ''}}">
                            </div>

                            <div class="form-group col-5">
                                <label for="contract_endDate">End Date</label>
                                <input id="contract_endDate" type="date" class="form-control" value="{{$broker->contract_endDate ?? ''}}" name="contract_endDate">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-footer d-flex justify-content-center">
            <button type="submit" class="btn btn-info w-25">Submit</button>
        </div>
    </form>
</div>

<script src="{{asset('asset/plugins/jquery/jquery.min.js')}}"></script>
<script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
<script type="text/javascript">

$(document).ready(function() {
    $('#hasContract').change(function() {
        if($(this).is(":checked")) {
           $('#contractData').fadeIn();
           $('#hasContract').val($(this).is(':checked'));
        }else{
            $('#contractData').fadeOut();
        }
    });
});
</script>
@endsection