@extends ('../welcome')


@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Buildings</h3><br>
            <p>Total: {{ count($buildings) }}</p>
            <a href="{{ route('buildings.restoreAll') }}" title="Restore All" style="float:right">
                <button class="btn btn-square btn-outline-success" type="button"><i
                        class="fas fa-trash-restore-alt"></i></button>
            </a>
        </div>
        <!-- /.card-header -->
        <div class="card-body">
            <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('buildings-archive-export') ? 'example1' : 'nonExport' }} 
                class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Phase Name</th>
                        <th>Project Name</th>
                        <th>Created Date</th>
                        <th>Created Time</th>
                        <th>Restore</th>
                    </tr>
                </thead>
                <tbody>

                    @forelse ($buildings as $building)
                        <?php
                        $temp = explode(' ', $building->created_at);
                        ?>
                        <tr>
                            <td>{{ $building?->id }}</td>
                            <td>
                                <a href="{{ route('buildings.show', $building->id) }}">
                                    {{ $building->name }}
                                </a>
                            </td>
                            <td>

                                @if ($building->phase?->id)
                                    <a href="{{ route('phases.show', $building->phase->id) }}">
                                        {{ $building->phase->name }}
                                    </a>
                                @endif
                            </td>
                            <td>
                                @if ($building->phase?->id)
                                    <a href="{{ route('projects.show', $building->phase->project->id) }}">
                                        {{ $building->phase->project->name }}
                                    </a>
                                @endif
                            </td>
                            <td>{{ $temp[0] }}</td>
                            <td>{{ $temp[1] }}</td>

                            <td>
                                <a class="btn btn-outline-light" title="Restore"
                                    href="{{ route('buildingsRestore', $building->id) }}">
                                    <i class="fas fa-trash-restore-alt"></i>
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>No buildings yet</tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
@endsection
