@extends ('../welcome')


@section ('content')
<div class="card col-6"> 
    <div class="card-body register-card-body">
        <p class="login-box-msg">Add New Campaign</p>
        <form action="{{ route('campaigns.store') }}" method="POST">
            @csrf
            <div class="form-group mb-3">
                <label>Name</label>
                <input type="text" name="name" value="{{old('name')}}" class="form-control">
            </div>
            <div class="form-group mb-3">
                <label>Description</label>
                <textarea type="text" class="form-control" cols="6" rows="8" value="{{old('description')}}"
                    name="description"></textarea>
            </div>
            <div class="form-group mb-3">
                <label>Status</label>
                <select name="status" class="select2 custom-select form-control-border" id="status">
                    <option value="planning">Planning</option>
                    <option value="active">Active</option>
                    <option value="inactive">In-Active</option>
                    <option value="complete">Complete</option>
                </select>
            </div>
            <div class="form-group mb-3">
                <label>Start Date</label>
                <input id="startDate" type="date" class="form-control" value="{{old('start_date')}}" name="start_date">
            </div>
            <div class="form-group mb-3">
                <label>End Date</label>
                <input type="date" id="endDate" class="form-control" value="{{old('end_date')}}" name="end_date">
            </div>
            <div class="form-group mb-3">
                <label>Budget</label>
                <input type="number" step="0.01" class="form-control" value="{{old('budget')}}" name="budget">
            </div>
            <div class="form-group mb-3">
                <label>Target</label>
                <input type="text" class="form-control" value="{{old('target')}}" name="target">
            </div>
            <div class="form-group mb-3">
                <label>Purpose</label>
                <input type="text" class="form-control" value="{{old('purpose')}}" name="purpose">
            </div>
            {{--<div class="form-group mb-3">
                <label>Type</label>
                <select name="type" class="select2 custom-select form-control-border" id="type">
                    <option value="facebook">Facebook</option>
                    <option value="twitter">Twitter</option>
                    <option value="instagram">Instagram</option>
                    <option value="google-ads">Google Ads</option>
                </select>
            </div>--}}
            <div class="form-group mb-3">
                <label>Projects</label>
                <select name="project_id" class="select2 custom-select form-control-border" id="project">
                    <option value=""></option>
                    @forelse($projects as $project)
                    <option value="{{$project->id}}">{{$project->name}}</option>
                    @empty
                    @endforelse
                </select>
            </div>
            <div class="col-6" style="float:right;">
                <button type="submit" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>
</div>

<script>
$("#startDate").change(function() {
    const date = new Date();

    let day = date.getDate();
    let month = date.getMonth() + 1;
    let year = date.getFullYear();
    let currentDate = `${year}-${month}-${day}`;

    
    console.log(currentDate);
    console.log(this.value);
});
</script>
@endsection