@extends ('../welcome')


@section('content')
    <div class="card card-info card-outline collapsed-card col-12">
        <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
            <div class="card-title">
                Filter
            </div>
        </div>
        <div class="card-body">
            <form>
                <div class="row">
                    <div class='col-6'>
                        <div class="col-12">
                            <div class="form-group">
                                <label>Projects</label>

                                <select name="project_id[]" class="select2 custom-select form-control-border" multiple>
                                    @foreach ($projects as $project)
                                        <option value="{{ $project->id }}" 
                                            {{ in_array($project->id, request()->get('project_id', [])) ? 'selected' : '' }}>
                                            {{ $project->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="form-group">
                                <label>Campaigns</label>

                                <select name="campaign_id[]" class="select2 custom-select form-control-border" multiple>
                                    @foreach ($allCampaigns as $campaignn)
                                        <option value="{{ $campaignn->id }}" 
                                            {{ in_array($campaignn->id, request()->get('campaign_id', [])) ? 'selected' : '' }}>
                                            {{ $campaignn->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="form-group">
                                <label>Status</label>
                                <select name="status[]" class="select2 custom-select form-control-border" multiple>
                                    <option value="planning" {{ in_array('planning', request()->get('status', [])) ? 'selected' : '' }}>Planning</option>
                                    <option value="active" {{ in_array('active', request()->get('status', [])) ? 'selected' : '' }}>Active</option>
                                    <option value="inactive" {{ in_array('inactive', request()->get('status', [])) ? 'selected' : '' }}>In-Active</option>
                                    <option value="complete" {{ in_array('complete', request()->get('status', [])) ? 'selected' : '' }}>Complete</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="row">
                            <div class="form-group col-6">
                                <label>From</label>
                                <input type="time" class="form-control" value="{{ request()->get('time1', '') }}"
                                    name="time1">
                            </div>
                            <div class="form-group col-6">
                                <label>to</label>

                                <input type="time" name="time2" value="{{ request()->get('time2', '') }}"
                                    class="form-control">
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-6">
                                <input type="date" name="date1" value="{{ request()->get('date1', '') }}"
                                    class="form-control">
                            </div>
                            <div class="form-group col-6">
                                <input type="date" name="date2" value="{{ request()->get('date2', '') }}"
                                    class="form-control">
                            </div>
                        </div>
                        <label>Budget Range</label>
                        <div class="row">
                            <div class="form-group col-6">
                                <input type="text" name="budget1" value="{{ request()->get('budget1', '') }}" 
                                    class="form-control">
                            </div>
                            <div class="form-group col-6">
                                <input type="text" name="budget2" value="{{ request()->get('budget2') }}" placeholder="L.E"
                                    class="form-control">
                            </div>
                        </div>

                        <a href="{{ url()->previous() }}" class="btn btn-default">Back</a>
                        <button type="submit" class="btn btn-info" style="float:right">filter</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!-- End filters -->

    <!-- /.row -->
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title">Campaigns</div> 
                <div style="float:right">
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('campaigns-export'))
                        <a href="{{ route('campaigns.export', request()->query()) }}" class="btn btn-outline-primary" title="Export to Excel">
                            <i class="fas fa-file-excel"></i> Export
                        </a>
                    @endif
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('campaigns-create'))
                        <a href="{{ route('campaigns.create') }}" style="margin-left: 5px;">
                            <button class="btn btn-square btn-light active" type="button">
                                <i class="fas fa-plus"></i>
                            </button>
                        </a>
                    @endif
                </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <div class="card-title">Total: {{ $campaigns->total() }}</div>
            </div>
            <div class="card-body">
                <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('campaigns-export') ? 'example1' : 'nonExport' }} 
                    class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Status</th>
                            <th>Budget</th>
                            <th>Target</th>
                            <th>Purpose</th>
                            <th>Project</th>
                            <th>Created Date</th>
                            <th>Created Time</th>

                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($campaigns as $campaign)
                            <?php $temp = explode(' ', $campaign->created_at); ?>

                            <tr>
                                <td>{{ $campaign->id }}</td>
                                <td>{{ $campaign->name }}</td>
                                <td>{{ $campaign->status }}</td>
                                <td>{{ $campaign->budget }}</td>
                                <td>{{ $campaign->target ?? '' }}</td>
                                <td>{{ $campaign->purpose ?? '' }}</td>
                                @if (!empty($campaign->project))
                                    <td>
                                        <a href="{{ route('projects.show', $campaign->project->id) }}">
                                            {{ $campaign->project->name }}
                                        </a>
                                    </td>
                                @else
                                    <td></td>
                                @endif
                                <td>{{ $temp[0] }}</td>
                                <td>{{ $temp[1] }}</td>
                                <td>
                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('campaigns-edit'))
                                        <a class="btn btn-primary" title="Edit"
                                            href="{{ route('campaigns.edit', $campaign->id) }}">
                                            <i class="fa fa-pen"></i>
                                        </a>
                                    @endif

                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('campaigns-show'))
                                        <a class="btn btn-warning" title="Show"
                                            href="{{ route('campaigns.show', $campaign->id) }}">
                                            <i class="fa fa-eye"></i>
                                        </a>
                                    @endif

                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('campaigns-delete'))
                                        @if (count($campaign->leads) == 0 && count($campaign->sources) == 0)
                                            <button onClick="clickDeletebutton(this)" title="Delete" class="btn btn-danger"
                                                data-id="{{ $campaign->id }}" data-toggle="modal"
                                                data-target="#exampleModalCenter">
                                                <i class="fa fa-ban"></i>
                                            </button>
                                        @endif
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>

                </table>
                <div class="pagination">
                    {{ $campaigns->appends(request()->input())->links() }}
                </div>
                <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog"
                    aria-labelledby="exampleModalCenter" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Delete Record</h5>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure to delete this record ?</p>
                            </div>
                            <form class="modal-footer" method="post">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>
    <!-- /.row -->
    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('campaigns.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }

        function updateTextInput(val) {
            document.getElementById('textInput').value = val;
        }
    </script>
@endsection
