@extends ('../welcome')
@section('content')
    <div class="row">

        <div class="col-md-6">

            <div class="card">
                <div class="card-header">
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                            <!-- <i class="fas fa-minus"></i> -->
                        </button>
                    </div>
                    <h3 class="card-title">
                        {{ $campaign->name }} Campaign Data
                    </h3>
                </div>
                <div class="card-body">
                    <dl class="row">
                        <dt class="col-sm-4">Name :</dt>
                        <dd class="col-sm-8">{{ $campaign->name }}</dd>
                    </dl>
                    <dl class="row">
                        @if (!empty($campaign->project->id))
                            <dt class="col-sm-4">Project :</dt>
                            <dd class="col-sm-8">
                                <a href="{{ route('projects.show', $campaign->project->id) }}">
                                    {{ $campaign->project->name }} </a>
                            </dd>
                        @endif
                    </dl>
                    <dl class="row">
                        <dt class="col-sm-4">Description :</dt>
                        <dd class="col-sm-8">{{ $campaign->description }}</dd>
                    </dl>
                    <dl class="row">
                        <dt class="col-sm-4">Status :</dt>
                        <dd class="col-sm-8">{{ $campaign->status }}</dd>
                    </dl>

                    <dl class="row">
                        <dt class="col-sm-4">Start Date :</dt>
                        <dd class="col-sm-8">{{ $campaign->start_date }}</dd>
                    </dl>

                    <dl class="row">
                        <dt class="col-sm-4">End Date :</dt>
                        <dd class="col-sm-8">{{ $campaign->end_date }}</dd>
                    </dl>

                    <dl class="row">
                        <dt class="col-sm-4">Budget :</dt>
                        <dd class="col-sm-8">{{ $campaign->budget }}</dd>
                    </dl>
                    <dl class="row">
                        <dt class="col-sm-4">Target :</dt>
                        <dd class="col-sm-8">{{ $campaign->target ?? '' }}</dd>
                    </dl>
                    <dl class="row">
                        <dt class="col-sm-4">Purpose :</dt>
                        <dd class="col-sm-8">{{ $campaign->purpose ?? '' }}</dd>
                    </dl>
                    {{--<dl class="row">
                        <dt class="col-sm-4">Type :</dt>
                        <dd class="col-sm-8">{{ $campaign->type }}</dd>
                    </dl>--}}
                    
                    <div style="margin-bottom:10px; float:right">
                        @if (auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('campaigns-edit'))
                            <a class="btn btn-info" title="Edit" href="{{ route('campaigns.edit', $campaign->id) }}">
                                <i class="fa fa-pen"></i>
                            </a>
                        @endif

                        @if (auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('campaigns-delete'))
                            @if (count($campaign->leads) == 0 && count($campaign->sources) == 0)
                                <button onClick="clickDeletebutton(this)" title="Delete" class="btn btn-danger"
                                    data-id="{{ $campaign->id }}" data-toggle="modal" data-target="#exampleModalCenter">
                                    <i class="fa fa-ban"></i>
                                </button>
                            @endif
                        @endif

                    </div>
                </div>
            </div>
        </div>
        <div class="col-6">
            <div class="card">
                <div class="card-header">
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                    <h3 class="card-title">
                        Leads
                    </h3>
                    <!-- <h5>Leads</h5> -->
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('campaign-leads-export') ? 'leads' : 'nonExport' }} 
                        class="display table table-bordered table-striped">
                        <thead>
                            <tr>

                                <th>ID</th>
                                <th>Name</th>
                                <th>Status</th>
                                <th>Assigned User</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($campaign->leads as $lead)
                                <tr>
                                    <td>{{ $lead->id }}</td>
                                    <td>
                                        @if (auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('leads-show'))
                                            <a href="{{ route('leads.show', $lead->id) }}">
                                                {{ $lead->name }}
                                            </a>
                                        @else
                                            <a>
                                                {{ $lead->name }}
                                            </a>
                                        @endif
                                    </td>
                                    <td>{{ $lead->status == 'converted' ? 'client' : $lead->status }}</td>
                                    <td>
                                        <a>
                                            {{ $lead->user->name ?? '' }}
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                </div>
                <div class="modal-body">
                    <p>Are you sure to delete this record ?</p>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>


    <script src="https://code.jquery.com/jquery-3.5.1.js"></script>
    <script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.min.js"></script>
    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('campaigns.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }
    </script>
@endsection
