@extends ('../welcome')
@section('content')
<form method="post" action="{{route('storeReservationContract')}}">
    @csrf

    <div class="row">
        <div class="card card-info card-outline col-4">
            <div class="card-header">
                client data
            </div>
            <div class="card-body">
                <div class=" row">
                    <label class="col-sm-5 col-form-label">Name :</label>
                    <input name="client_name" type="text" class="form-control col-7" value="{{ $client->name ?? '-' }}">
                    <input name="client_id" type="hidden" value="{{ $client->id ?? '-' }}">
                </div><br>
                <div class=" row">
                    <label class="col-sm-5 col-form-label">Job Title :</label>
                    <input name="job_title" type="text" class="form-control col-7"
                        value="{{ $client->job_title ?? '-' }}">
                </div><br>
                <div class=" row">
                    <label class="col-sm-5 col-form-label">Email :</label>
                    <input name="email" type="email" class="form-control col-7" value="{{ $client->email ?? '-' }}">
                    </label>
                </div><br>
                <div class=" row">
                    <label class="col-sm-5 col-form-label">phone number :</label>
                    @forelse($client->phone_numbers as $phone)
                    <input name="phone" type="text" class="form-control col-7" value="{{ $phone->phone ?? '-' }}">
                    @break
                    @empty
                    <input name="phone" type="text" class="form-control col-7" value="">
                    @endforelse
                </div><br>
                <div class=" row">
                    <label class="col-sm-5 col-form-label">Civil ID Date :</label>
                    <input name="civil_date" type="text" class="form-control col-7"
                        value="{{ $client->civil_date ?? '-' }} ">
                </div><br>
                <div class=" row">
                    <label class="col-sm-5 col-form-label">Civil ID City :</label>
                    <input name="civil_city" type="text" class="form-control col-7"
                        value="{{ $client->civil_city ?? '-' }} ">
                </div><br>
                <div class=" row">
                    <label class="col-sm-5 col-form-label">Civil ID Number :</label>
                    <input name="civil_number" type="text" class="form-control col-7"
                        value="{{ $client->civil_number ?? '-' }} ">
                </div><br>
                <div class=" row">
                    <label class="col-sm-5 col-form-label">Civil ID Address :</label>
                    <input name="civil_address" type="text" class="form-control col-7"
                        value="{{ $client->civil_address ?? '-' }} ">
                </div><br>
                <div class=" row">
                    <label class="col-sm-5 col-form-label">Nationality :</label>
                    <input name="nationality" type="text" class="form-control col-7"
                        value="{{ $client->nationality ?? '-' }} ">
                </div><br>
            </div>
        </div>
        <div class="card card-danger card-outline col-4">
            <div class="card-header">
                Unit Data
            </div>
            <div class="card-body">
                <div class=" row">
                    <label class="col-sm-5 col-form-label">Unit Name:</label>
                    <input name="unit_name" type="text" class="form-control col-7" value="{{ $unit->name ?? '-' }} ">
                    <input name="unit_id" type="hidden" value="{{ $unit->id}} ">
                </div><br>

                <div class=" row">
                    <label class="col-sm-5 col-form-label">Floor</label>
                    <input name="floor" type="text" class="form-control col-7" value="{{ $unit->floor ?? '-' }} ">
                </div><br>
                <div class=" row">
                    <label class="col-sm-5 col-form-label">unit Space :</label>
                    <input name="unit_space" type="text" class="form-control col-7"
                        value="{{ $unit->unit_space ?? '-' }} ">
                </div><br>

                <div class=" row">
                    <label class="col-sm-5 col-form-label">Unit Total Price :</label>
                    <input name="total_price" type="text" class="form-control col-7"
                        value="{{ $payment->total_price ?? '-' }} ">
                </div><br>

                <div class=" row">
                    <label class="col-sm-5 col-form-label">Mentainance :</label>
                    <input name="mentainance" type="text" class="form-control col-7"
                        value="{{ $payment->mentainance ?? '-' }} ">
                </div><br>

                <div class=" row">
                    <label class="col-sm-5 col-form-label">Reservation Amount :</label>
                    <input name="reservation" type="text" class="form-control col-7"
                        value="{{ $payment->reservation ?? '-' }} ">
                </div><br>
                <button class="btn btn-info col-12" type="submit" style="margin-top:30%">submit</button>
            </div>
        </div>


        <div class="card card-success card-outline col-4">
            <div class="card-header">
                Payment data
            </div>
            <div class="card-body">
                <div class=" row">
                    <label class="col-6 col-form-label">Booked Date :</label>
                    <label class="col-6 col-form-label">{{$unit->Booked_date ?? date('Y-m-d')}}</label>
                    <input name="booked_date" type="hidden" value="{{$unit->Booked_date ?? date('Y-m-d')}}">
                </div><br>

                <div class=" row">
                    <label class="col-6 col-form-label">Booked Day :</label>
                    <label class="col-6 col-form-label">{{$c_day}}</label>
                    <input name="booked_day" type="hidden" value="{{$c_day}}">
                </div><br>

                <div class=" row">
                    <label class="col-6 col-form-label">Batches Amount :</label>
                    <input name="batches_amount" value="{{$unit->batches_amount ?? ''}}" type="number" step="any" class="form-control col-6">
                </div><br>

                <div class=" row">
                    <label class="col-6 col-form-label">Batches Quantity :</label>
                    <input name="batches_qty" type="number" step="any" value="{{$unit->batches_qty ?? ''}}" class="form-control col-6">
                </div><br>

                <div class=" row">
                    <label class="col-6 col-form-label">Batches Duration :</label>
                    <input name="batches_payment_duration" type="number" step="any" value="{{$unit->batches_payment_duration ?? ''}}" class="form-control col-6">
                </div><br>

                <label class="col-6 col-form-label">Payment Method:</label>
                <div class=" row">
                    <input name="payment_method" type="radio" class="col-1" value="installment" checked>
                    <label class="col-4 col-form-label" >Installment</label>

                    <input name="payment_method" type="radio" class="col-1" value="cash">
                    <label class="col-4 col-form-label">Cash</label>

                </div>
            </div>
        </div>
    </div>

</form>

    <script src="{{ asset('asset/plugins/jquery/jquery.min.js') }}"></script>
    <script>
        // Remove leading zeros from phone number input
        $(document).ready(function() {
            $('input[name="phone"]').on('input', function() {
                var phoneNumber = $(this).val();
                
                // Remove leading zeros but keep the value if it's just "0"
                if (phoneNumber.length > 1 && phoneNumber.startsWith('0')) {
                    $(this).val(phoneNumber.replace(/^0+/, ''));
                }
            });
            
            // Also handle on blur (when user leaves the field)
            $('input[name="phone"]').on('blur', function() {
                var phoneNumber = $(this).val();
                if (phoneNumber.length > 1 && phoneNumber.startsWith('0')) {
                    $(this).val(phoneNumber.replace(/^0+/, ''));
                }
            });
        });
    </script>
@endsection