@extends ('../welcome')
@section('content')
    <link rel="stylesheet" href="{{ asset('swiper/swiper.css') }}">
    <style>
        .clickable-row:hover {
            background-color: #fff;
            color: black;
            cursor: pointer;
        }

        a:hover {
            cursor: pointer;

        }

        #upload-photo {
            display: none;
        }

        #upload-file {
            display: none;
        }

        #carouselExampleControls .btn {
            position: absolute;
            top: 0%;
            right: 0%;
            background-color: transparent;

            opacity: 0.5;
            color: white;
            border: none;
            cursor: pointer;
            border-radius: 5px;
            color: grey;
        }

        .w-100 {
            height: 400px !important
        }

        #carouselExampleControls .btn:hover {
            background-color: transparent;
            opacity: 3.0;
            color: white;
        }

        /* swiper ////////////////////////////////////*/
        .swiper {
            width: 240px;
            height: 320px;
        }

        .swiper .swiper-slide {
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 18px;
            font-size: 22px;
            font-weight: bold;
            color: #fff;
        }


        .swiper2 {
            width: 100%;
            padding-top: 50px;
            padding-bottom: 50px;
        }

        .swiper2 .swiper-slide {
            background-position: center;
            background-size: cover;
            width: 300px;
            height: 300px;
        }

        .swiper2 .swiper-slide img {
            display: block;
            width: 100%;
        }
    </style>

    {{-- Main Card --}}
    <div class="card card-info card-outline">
        <div class="card-header">
            <div class="row">
                <form action="{{ route('ClientfileUpload') }}" method="POST" enctype="multipart/form-data" class="">
                    @csrf
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('clients-uploadImages'))
                        <label for="upload-photo" class="btn btn-outline-success" title="upload image">
                            <i class="fas fa-file-image"></i> &nbsp;
                            <i class="fas fa-upload"></i>
                        </label>
                        <input type="file" name="images[]" id="upload-photo" multiple>
                    @endif

                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('clients-uploadFiles'))
                        <label for="upload-file" class="btn btn-outline-danger" title="attach files">
                            <i class="fas fa-file-pdf"></i> &nbsp;
                            <i class="fas fa-upload"></i>
                        </label>
                        <input type="file" name="files[]" id="upload-file" multiple>
                    @endif

                    <input type="hidden" value="{{ $client->id }}" name="client_id">

                    <button type="submit" title="upload" style="margin-bottom:10px;" class="btn btn-outline-info"><i
                            class="fas fa-check"></i></button>
                </form>


                <div class="col-7"></div>
                @if (empty($client->lead))
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('clients-toLead'))
                        <a href="{{ route('toLead', $client->id) }}" style="float:right">
                            <button class="btn btn-square btn-outline-success" title=" Convert to lead" type="button"
                                style="float:right;">
                                <i class="fas fa-recycle"></i>
                            </button>
                        </a>
                    @endif
                @endif

                @if (auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('clients-edit'))
                    <a href="{{ route('clients.edit', $client->id) }}" style="float:right">
                        <button class="btn btn-square btn-outline-info" title=" Edit Client" type="button"
                            style="float:right;">
                            <i class="fas fa-pen"></i>
                        </button>
                    </a>
                @endif

                @if ($freeUnits == 0)
                    <a href="" style="float:right">
                        <button class="btn btn-square btn-outline-light" title="There is no available units right now"
                            type="button" style="float:right;" disabled>
                            <i class="fas fa-door-closed"></i>
                        </button>
                    </a>
                @else
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('clients-makeReservation'))
                        <a href="{{ route('Reservation.form', $client->id) }}" style="float:right">
                            <button class="btn btn-square btn-outline-dark" title=" Make Reservation" type="button"
                                style="float:right;">
                                <i class="fas fa-door-open"></i>
                            </button>
                        </a>
                    @endif
                @endif

            </div>
        </div>
        <div class="card-body">
            <div class="row">
                {{-- Client Data --}}
                <div class="card col-5">
                    <div class="card-body">
                        <table>
                            <tr>
                                <th>Name :</th>
                                <td>{{ $client->name ?? '-' }}</td>
                            </tr>
                            @if ($client->lead)
                                <tr>
                                    <th>Lead :</th>
                                    <td>
                                        <a href="{{ route('leads.show', $client->lead->id) }}">
                                            Lead History
                                        </a>
                                    </td>
                                </tr>
                            @endif
                            <tr>
                                <th>Email :</th>
                                <td>{{ $client->email ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Job Title :</th>
                                <td>{{ $client->job_title ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Came From :</th>
                                <td>{{ $client->came_from ?? '-' }}</td>
                            </tr>
                            @if ($client->source_id != null && $client->campaign_id != null)
                                <tr>
                                    <th>Campaign :</th>
                                    <td>
                                        <a href="{{ route('campaigns.show', $client->campaign_id) }}">
                                            {{ $client->campaign->name }}
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Source :</th>
                                    <td>
                                        <a href="{{ route('sources.show', $client->source_id) }}">
                                            {{ $client->source->name }}
                                        </a>
                                    </td>
                                </tr>
                            @endif
                            <tr>
                                <th>Status :</th>
                                <td>{{ $client->status ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Civil ID Date :</th>
                                <td>{{ $client->civil_date ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Civil ID City :</th>
                                <td>{{ $client->civil_city ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Civil ID Number :</th>
                                <td>{{ $client->civil_number ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Civil ID Address :</th>
                                <td>{{ $client->civil_address ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Nationality :</th>
                                <td>{{ $client->nationality ?? '-' }}</td>
                            </tr>
                            <tr>
                                <th>Assigned To :</th>
                                <td>{{ $client->user ? $client->user->name : '-' }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="col-7">
                    {{-- Phone Number --}}
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('clients-phoneNumbers'))
                        @if (auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('clients-create-PhoneNumber'))
                            <button type="button" class="btn btn-" style="float:right;color:#17a2b8" title="add new number"
                                data-toggle="modal" data-target="#storePhones">
                                <i class="fas fa-phone"></i>
                                <i class="fas fa-plus"></i>
                            </button>
                            <br>
                        @endif

                        <div class="card card-info card-outline" style="margin-top:17px">
                            <div class="card-body table-responsive p-0">
                                <table class="table table-hover text-nowrap">
                                    <tbody>
                                        @forelse($client->phone_numbers as $phone)
                                            <tr>
                                                <td>
                                                    <a href="https://wa.me/{{ $phone->country->phonecode }}{{ $phone->phone }}" target="_blank">
                                                        {{ $phone->country->phonecode }} {{ $phone->phone }}
                                                    </a>
                                                </td>
                                                <td>
                                                    @if (auth()->user()->type == 'admin' ||
                                                            auth()->user()->role->hasPermission('clients-edit-phoneNumber'))
                                                        <a class="btn btn-light"
                                                            href="{{ route('phones.edit', $phone->id) }}">
                                                            <i class="fas fa-pen" style="color:#17a2b8"></i>
                                                        </a>
                                                    @endif
                                                    @if (count($client->phone_numbers) > 1)
                                                        @if (auth()->user()->type == 'admin' ||
                                                                auth()->user()->role->hasPermission('clients-delete-phoneNumber'))
                                                            <button onClick="clickDeletePhone(this)" title="Delete"
                                                                type="button" style="height:38px;" class="btn btn-light"
                                                                data-id="{{ $phone->id }}" data-toggle="modal"
                                                                data-target="#phoneDelete">
                                                                <i class="fa fa-trash" style="color:#dc3545"></i>
                                                            </button>
                                                        @endif
                                                    @endif

                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td></td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    @endif

                    {{-- Access Users --}}
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('clients-AccessUsers'))
                        <div class="card card-info card-outline">
                            <div class="card-header">
                                Access Users
                            </div>
                            <div class="card-body">
                                <form action="{{ route('AccessUsers') }}" method="post" id="AssignForm">
                                    @csrf

                                    <div class="row">
                                        <div class="form-group col-9">
                                            <input type="hidden" name="client_id" value="{{ $client->id }}">
                                            <select name="user_id[]" class="select2 custom-select form-control-border"
                                                id="user_id" multiple>
                                                <option value=""></option>
                                                @foreach ($users as $user)
                                                    @if (in_array($user->id, $clientUsers))
                                                        <option value="{{ $user->id }}" selected>{{ $user->name }}
                                                        </option>
                                                    @else
                                                        <option value="{{ $user->id }}">{{ $user->name }}</option>
                                                    @endif
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group col-2">
                                            <button type="submit" title="User with deadline"
                                                class="btn btn-outline-info">
                                                <i class="fas fa-check" aria-hidden="true"></i>
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    @endif

                    {{-- Units --}}
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('clients-units'))
                        <div class="card card-info card-outline collapsed-card">
                            <div class="card-header" data-card-widget="collapse">
                                <div class="card-text">Units</div>
                            </div>
                            <div class="card-body">
                                <ul>
                                    @foreach ($client->units as $unit)
                                        <li>
                                            <a href="{{ route('units.show', $unit->id) }}">
                                                {{ $unit->building->phase->project->name }} -
                                                {{ $unit->name }}
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    @endif

                    {{-- Client->files --}}
                    @if (count($client->files) != 0)
                        @if (auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('clients-files'))
                            <div class="card card-outline card-info collapsed-card">
                                <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                                    Files
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        @foreach ($client->files as $file)
                                            <tr>
                                                <td>
                                                    <a
                                                        href="{{ URL::to('/') }}/files/{{ $file->file }}">{{ $file->file }}-{{ $file->created_at }}</a>
                                                </td>
                                                <td>
                                                    <form method="POST"
                                                        action="{{ route('files.destroy', $file->id) }}">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-outline-danger">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                    </button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </table>
                                </div>
                            </div>
                        @endif
                    @endif

                    <!-- Swiper -->
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('clients-gallery'))
                        <div class="card card-outline card-info collapsed-card">
                            <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                                Images
                            </div>
                            <div class="card-body">
                                <div class="col-12 pb-3">
                                    <div class="swiper mySwiper" id="mySwiper" data-toggle="modal"
                                        data-target="#imageGallery">
                                        <div class="swiper-wrapper">
                                            @foreach ($client->images as $key => $value)
                                                <div class="swiper-slide">
                                                    <img class="swiper-slide"
                                                        src="{{ URL::to('/') }}/images/{{ $value->name }}"
                                                        alt="{{ $value->name }}" />
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif

                </div>
            </div>
        </div>
    </div>
    {{-- Comments and Tickets Row --}}
    <div class=" row">
        <div class="col-5">
            <div class="card">
                {{-- Client Comments --}}
                @if (auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('clients-read-comment'))
                    <div class="card card-outline card-info  collapsed-card col-12">
                        <div class="card-header" data-card-widget="collapse">
                            <h3 class="card-title">
                                (Comments)
                            </h3>
                            @if (auth()->user()->type == 'admin' ||
                                    auth()->user()->role->hasPermission('clients-create-comment'))
                                <button type="button" class="btn btn-outline-info" style="float:right;"
                                    title="add comment" data-toggle="modal" data-target="#addComment">
                                    <i class="fas fa-plus"></i>
                                </button>
                            @endif
                        </div>
                        <div class="card-body">
                            @foreach ($streams as $stream)
                                <table>
                                    <tbody>
                                        <tr>
                                            <th>Comment: </th>
                                            <td>{{ $stream->comment ?? '' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Creator: </th>
                                            <td>{{ $stream->creator?->name ?? '' }}</td>
                                        </tr>
                                        <tr>
                                            <th>created_at :</th>
                                            <td>{{ $stream->created_at ?? '' }}</td>
                                        </tr>
                                    </tbody>
                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('clients-delete-comments'))
                                        <tfoot>
                                            <tr>
                                                <div style="float: right;">
                                                    <form method="POST"
                                                        action="{{ route('streams.destroy', $stream->id) }}">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-outline-danger">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </div>
                                            </tr>
                                        </tfoot>
                                    @endif
                                </table>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
        </div>
        <div class="col-7">

            <div class="card">
                {{-- Client Tickets --}}
                @if (auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('clients-tickets'))
                    @foreach ($client->units as $unit)
                        @if (count($unit->tickets) != 0)
                            <div class="card card-outline card-info collapsed-card">
                                <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                                    Tickets
                                </div>
                                <div class="card-body">
                                    @foreach ($unit->tickets as $ticket)
                                        <div class="card collapsed-card">
                                            <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                                                <h3 class="card-title">
                                                    {{ $unit->building->phase->project->name }} -
                                                    {{ $unit->name }}
                                                </h3>
                                            </div>
                                            <div class="card-body">
                                                @if (Auth::user()->type == 'admin' ||
                                                        auth()->user()->role->hasPermission('units-show'))
                                                    <a href="{{ route('units.show', $unit->id) }}" title="View Unit"
                                                        class="btn btn-" style="float:right">
                                                        <i class="fas fa-home"></i>
                                                    </a>
                                                @endif
                                                <table class="table table-bordered">
                                                    <thead>
                                                        <tr>
                                                            <th>ID</th>
                                                            <th>Ticket Type</th>
                                                            <th>Status</th>
                                                            <th>Description</th>
                                                            <th>Last Action Date</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach ($unit->tickets as $ticket)
                                                            <?php $temp = explode(' ', $ticket->created_at->setTimezone('Africa/Cairo')); ?>

                                                            @if (auth()->user()->type == 'admin' ||
                                                                    auth()->user()->role->hasPermission('clients-showTicket'))
                                                                <tr class='clickable-row'
                                                                    data-href='{{ route('tickets.show', $ticket->id) }}'>
                                                                @else
                                                                <tr>
                                                            @endif

                                                            <td>{{ $ticket->id }}</td>
                                                            <td>{{ $ticket->ticket_type->name }}</td>
                                                            <td>{{ $ticket->status }}</td>
                                                            <td>
                                                                {{ substr($ticket->description, 0, 20) }}{{ strlen($ticket->description) >= 20 ? '...' : '' }}
                                                            </td>
                                                            <td>{{ $ticket->updated_at }}</td>
                                                            </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                    @endforeach
                @endif
            </div>
        </div>

    </div>






    <!-- Modals -->

    <!-- Delete Image from Slider Modal -->
    <div class="modal fade" id="image" tabindex="-1" role="dialog" aria-labelledby="image" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                </div>
                <div class="modal-body">
                    <p>Are you sure to delete this Image ?</p>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-info" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>

    {{-- Add Comment --}}
    <div class="modal fade" id="addComment" tabindex="-1" role="dialog" aria-labelledby="addCommentLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addCommentLabel">add Comment</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('streams.store') }}" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <input class="form-control" name="client_id" type="hidden" value="{{ $client->id }}">
                            <input class="form-control" name="created_by" type="hidden"
                                value="{{ auth()->user()->id }}">
                            <textarea class="form-control" name="comment" required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-info">submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Store Phone Number -->
    <div class="modal fade" id="storePhones" role="dialog" aria-labelledby="storePhonesLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="storePhonesLabel">add new number</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('phones.store') }}" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <input class="form-control" name="client_id" type="hidden" value="{{ $client->id }}">
                        </div>
                        <div class="row">

                            <div class="form-group col-4">
                                <select class="select2 custom-select form-control-border" name="country_id" required>
                                    <option></option>
                                    @foreach ($codes as $code)
                                        <option value="{{ $code->id }}">{{ $code->name }}
                                            +{{ $code->phonecode }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-8">
                                <input type="text" class="form-control m-input" 
                                    placeholder="Phone Number" id ="phone" name="phone" required>
                                <div id="phone-error" style="display:none;"></div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-info">submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- gallery Image from Slider Modal -->
    <div class="modal fade" id="imageGallery" aria-modal="true" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content"
                style="background-color: unset;
                    box-shadow: unset;
                    border: unset;">
                <div class="modal-body">
                    <div class="swiper2 mySwiper2">
                        <div class="swiper-wrapper">
                            @foreach ($client->images as $key => $value)
                                <div class="swiper-slide">
                                    <img style="position: absolute" src="{{ URL::to('/') }}/images/{{ $value->name }}"
                                        alt="{{ $value->name }}" />
                                    <a href="{{ route('clients.deleteImage', $value->id) }}">
                                        <button style="position: relative; float:right;color:white;font-size:30px"
                                            class="btn">×</button>
                                    </a>
                                </div>
                            @endforeach
                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Phone Modal -->
    <div class="modal fade" id="phoneDelete" tabindex="-1" role="dialog" aria-labelledby="phoneDelete"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">

                <div class="modal-body">
                    <h5>Are you sure to delete this phone Number ?</h5>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-danger yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>
    <script type="module" src="{{ asset('swiper/swiper.js') }}"></script>
    <script>
        clickDeletePhone = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('phones.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#phoneDelete').find($('form')).attr('action', route);
        }

        jQuery(document).ready(function($) {
            $(".clickable-row").click(function() {
                window.location = $(this).data("href");
            });
        });


        DeleteImage = (image) => {
            console.log(image);
            const modelId = image.getAttribute("data-id");
            var route = "{{ route('galleries.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#image').find($('form')).attr('action', route);
        }
        
        // Remove leading zeros from phone number input
        function removeLeadingZeros() {
            // Use event delegation for dynamically loaded content
            $(document).off('input.phoneZeros').on('input.phoneZeros', 'input[name="phone"]', function() {
                var phoneNumber = $(this).val();
                console.log('Input event triggered:', phoneNumber);
                
                // Remove leading zeros but keep the value if it's just "0"
                if (phoneNumber.length > 1 && phoneNumber.startsWith('0')) {
                    var newValue = phoneNumber.replace(/^0+/, '');
                    console.log('Removing leading zeros:', phoneNumber, '->', newValue);
                    $(this).val(newValue);
                }
            });
            
            // Also handle on blur (when user leaves the field)
            $(document).off('blur.phoneZeros').on('blur.phoneZeros', 'input[name="phone"]', function() {
                var phoneNumber = $(this).val();
                console.log('Blur event triggered:', phoneNumber);
                
                if (phoneNumber.length > 1 && phoneNumber.startsWith('0')) {
                    var newValue = phoneNumber.replace(/^0+/, '');
                    console.log('Removing leading zeros on blur:', phoneNumber, '->', newValue);
                    $(this).val(newValue);
                }
            });
            
            // Also try with ID selector
            $(document).off('input.phoneZerosId').on('input.phoneZerosId', '#phone', function() {
                var phoneNumber = $(this).val();
                console.log('Input event triggered (by ID):', phoneNumber);
                
                if (phoneNumber.length > 1 && phoneNumber.startsWith('0')) {
                    var newValue = phoneNumber.replace(/^0+/, '');
                    console.log('Removing leading zeros (by ID):', phoneNumber, '->', newValue);
                    $(this).val(newValue);
                }
            });
        }
        
        // Initialize when document is ready
        $(document).ready(function() {
            removeLeadingZeros();
        });
        
        // Also initialize when modal is shown
        $(document).on('shown.bs.modal', '#storePhones', function() {
            console.log('Modal shown, reinitializing phone zero removal');
            removeLeadingZeros();
        });
    </script>
    <!-- Ensure jQuery is loaded only once and before any script that uses it -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        jQuery(document).ready(function($) {
            // Remove leading zeros from phone number input (works for dynamically loaded modals too)
            $(document).on('input', 'input[name="phone"]', function() {
                var phoneNumber = $(this).val();
                if (phoneNumber.length > 1 && phoneNumber.startsWith('0')) {
                    $(this).val(phoneNumber.replace(/^0+/, ''));
                }
            });
            $(document).on('blur', 'input[name="phone"]', function() {
                var phoneNumber = $(this).val();
                if (phoneNumber.length > 1 && phoneNumber.startsWith('0')) {
                    $(this).val(phoneNumber.replace(/^0+/, ''));
                }
            });
        });

        $(document).ready(function() {
            // Phone duplication check for client phone
            $(document).on('input', '#phone', function() {
                var phoneNumber = $(this).val();
                var countrySelect = $(this).closest('.row').find('select[name="country_id"]');
                var selectedCountryCode = countrySelect.find('option:selected').text().split('+').pop().trim();
                var errorDiv = $('#phone-error');
                if (phoneNumber.length > 3) {
                    $.ajax({
                        url: '{{ route('check-client-phone') }}',
                        type: 'POST',
                        data: {
                            phone: phoneNumber,
                            country_code: selectedCountryCode,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(response) {
                            if (response.exists) {
                                errorDiv.text('This Phone Number is Duplicated').show()
                                    .removeClass('valid-feedback').addClass('invalid-feedback');
                            } else {
                                errorDiv.text('Phone Number is available').show().removeClass(
                                    'invalid-feedback').addClass('valid-feedback');
                            }
                        },
                        error: function() {
                            errorDiv.text('Error occurred while checking the phone number')
                                .show().removeClass('valid-feedback').addClass(
                                    'invalid-feedback');
                        }
                    });
                } else {
                    errorDiv.hide();
                }
            });
        });
    </script>
@endsection
