@extends ('../welcome')

<style>
    .pagination nav .relative.z-0.inline-flex {
        display: inline-flex;
    }

    .pagination nav .hidden {
        display: unset !important;
    }

    .pagination nav .flex-1.justify-between {
        padding: 15px 0
    }

    .pagination nav .flex.justify-between.flex-1 {
        display: none
    }
</style>
@section('content')
    <!-- /.row -->
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title"> Actions Taking Place</div>
                {{-- <a href="{{ route('callActions.create') }}" class="btn btn-light" style="float:right"
                    title="create Call Actions">
                    <i style="color:black" class="fas fa-cog"></i>
                </a> --}}
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <div class="card-title">Total: {{ $communications->total() }}</div>

                <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('nextActions-export') ? 'example2' : 'nonExport' }} 
                    class="table table-bordered table-striped">
                    <thead>
                            <tr>
                                <th>ID</th>
                                <th>Lead Name</th>
                                <th>Phone</th>
                                <th>Status</th>
                                <th>Comment</th>
                                <th>Date</th>
                                <!--<th>Type</th>-->
                                <!--<th>Next Action Date</th>-->
                                <th>Created By</th>
                                <th>View</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($communications as $communication)
                                @if ($communication->broker_id == null && !empty($communication->lead))
                                    <tr>
                                        <td>{{ $communication->id }}</td>
                                        
                                        <td>
                                            @if (auth()->user()->type == 'admin' ||
                                                    auth()->user()->role->hasPermission('leads-show'))
                                                <a href="{{ route('leads.show', $communication->lead->id) }}">
                                                    {{ $communication->lead->name ?? '' }}
                                                </a>
                                            @else
                                                <a>
                                                    {{ $communication->lead->name ?? '' }}
                                                </a>
                                            @endif
                                        </td>
                                        <td>
                                            @foreach($communication->lead->phone_numbers as $phone)
                                                <li>
                                                    <a href="https://wa.me/{{$phone->country->phonecode}}{{$phone->phone}}" target="_blank">
                                                        {{$phone->country->phonecode}} {{$phone->phone}}
                                                    </a>
                                                </li>
                                            @endforeach
                                        </td>

                                        <td>
                                            {{ $communication->lead->LeadStatus->name }}
                                        </td>

                                        <td title="Open the Event To Change Status">
                                            {{ $communication->description }}
                                        </td>
                                    
                                        <td>{{ $communication->created_at }}</td>

                                        @if (auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('users-show'))
                                            <td>
                                                <a href="{{ route('users.show', $communication->user->id) }}">
                                                    {{ $communication->user?->name }}
                                                </a>
                                            </td>
                                        @endif
                                        
                                        <td>
                                            @if (auth()->user()->type == 'admin' ||
                                                    auth()->user()->role->hasPermission('communications-show'))
                                                <form action="" method="POST">
                                                    <a class="btn btn-light" title="Show"
                                                        href="{{ route('communications.show', $communication->id) }}">
                                                        <i class="fa fa-eye"></i>
                                                    </a>
                                                    @csrf
                                                </form>
                                            @endif
                                        </td>
                                    </tr>
                                    @endif
                            @endforeach
                        </tbody>
                </table>
                <div class="pagination">
                    {{ $communications->appends(request()->input())->links() }}
                </div>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.5.1.js"></script>
    <script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.min.js"></script>
@endsection
