@extends ('../welcome')
@section('content')
    <style>
        h5 {
            font-weight: bold;
            font-size: 20px;
            padding-right: 15px;
        }

        span {
            font-weight: 90px;
            font-size: 20px;
        }

        .callout a {
            text-decoration: none !important;
        }

        .callout a:hover {
            color: #17a2b8;
            font-weight: bold;
        }

        .custom-select {
            /* width: none; */
        }

        .btns {
            font-size: 15px !important;
        }

        th {
            width: 30%
        }
    </style>

    <div class="card callout callout-info col-5">
        <div class="card-header">
            <h3 class="card-title">
                <span>Action Details</span>
            </h3>
        </div>
        @if ($communication->broker_id == null)
            <div class="card-body">
                <table>
                    <tbody>
                        <tr>
                            <th>Lead Name:</th>
                            <td>
                                @if (auth()->user()->type == 'admin' ||
                                        auth()->user()->role->hasPermission('leads-show'))
                                    <a href="{{ route('leads.show', $communication->lead->id) }}">
                                        {{ $communication->lead->name }}
                                    </a>
                                @else
                                    <a>
                                        {{ $communication->lead->name }}
                                    </a>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>User Name:</th>
                            <td>
                                @if (auth()->user()->type == 'admin' ||
                                        auth()->user()->role->hasPermission('users-show'))
                                    <a href="{{ route('users.show', $communication->user->id) }}">
                                        {{ $communication->user->name }}
                                    </a>
                                @else
                                    <a>
                                        {{ $communication->user->name }}
                                    </a>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Status</th>
                            <td class="text-{{ $communication->CommunicationStatus?->color }}">
                                {{ $communication->CommunicationStatus?->name }}
                            </td>
                        </tr>

                        <tr>
                            <th>Description</th>
                            <td>{{ $communication->description }}</td>
                        </tr>

                        <tr>
                            <th>Title :</th>
                            <td style="font-weight:bold;color:#17a2b8;">
                                {{ $communication->event?->title }}
                            </td>
                        </tr>

                        <tr>
                            <th>Date of Action :</th>
                            @php
                                $date = strtotime($communication->event?->start);
                                $start = date('Y-m-d h:i:s', $date);
                            @endphp
                            <td>{{ $start }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="card-footer">
                {{-- @if (auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('brokers-reAssign-activities')) --}}
                    {{-- <button type="button" class="btn btn-info" title="ChangeStatus" data-toggle="modal"
                        data-target="#changeStatus" style="float:right">
                        ChangeStatus
                    </button> --}}
                {{-- @endif --}}
            </div>
        @else
            <div class="card-body">
                <table>
                    <tbody>
                        <tr>
                            <th>Type: </th>
                            <td>{{ $communication->type ?? '' }}</td>
                        </tr>
                        <tr>
                            <th>State: </th>
                            <td>{{ $communication->state ?? '' }}</td>
                        </tr>
                        <tr>
                            <th>Date: </th>
                            <td>{{ $communication->event->start ?? '' }}</td>
                        </tr>
                        <tr>
                            <th>Broker: </th>
                            <td>
                                <a href="{{ route('brokers.show', $communication->broker->id) }}">
                                    {{ $communication->broker?->name ?? '' }}
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <th>Agent: </th>
                            <td>
                                <a href="{{ route('agents.show', $communication->agent_id) }}">
                                    {{ $communication->agent->name ?? '' }}
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <th>User: </th>
                            <td>
                                <a href="{{ route('users.show', $communication->user->id) }}">
                                    {{ $communication->user->name ?? '' }}
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <th>Description: </th>
                            <td>{{ $communication->description ?? '' }}</td>
                        </tr>
                        @if ($communication->check_in == 0)
                            <tr>
                                <th>Reminder: </th>
                                <td>{{ $communication->reminder ?? '--' }}</td>
                            </tr>
                        @else
                            <tr>
                                <th>Close: </th>
                                <td>{{ $communication->event->end ?? '' }}</td>
                            </tr>
                        @endif
                    </tbody>
                </table>
            </div>
            <div class="card-footer">
                @if ($communication->check_in == 0)
                    <table>
                        <tbody>
                            <tr>
                                <td>
                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('brokers-checkIn-activities'))
                                        <button type="button" class="btn btn-success" title="checkIn" data-toggle="modal"
                                            data-target="#CheckIn">
                                            Check In
                                        </button>
                                    @endif
                                </td>
                                <td>
                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('brokers-edit-activities'))
                                        <button type="button" class="btn btn-info" title="edit activity"
                                            data-toggle="modal" data-target="#editActivity">
                                            Edit
                                        </button>
                                    @endif
                                </td>
                                <td>
                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('brokers-reAssign-activities'))
                                        <button type="button" class="btn btn-warning" title="Re-assign User"
                                            data-toggle="modal" data-target="#reAssignUser">
                                            Re-assign user
                                        </button>
                                    @endif
                                </td>
                            </tr>
                        </tbody>
                    </table>
                @endif
            </div>
        @endif
    </div>
    {{-- Edit Communication --}}
    <div class="modal fade" id="editActivity" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Create Activity </h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form action="{{ route('communications.update', $communication->id) }}" method="POST">

                    <div class="modal-body">
                        @csrf
                        @method('PUT')
                        <table>
                            <tbody>
                                <tr>
                                    <td>
                                        <label for="type">Type: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="type" class="select2 custom-select form-control-border"
                                            id="type">
                                            <option value="call" {{ $communication->type == 'call' ? 'selected' : '' }}>
                                                call
                                            </option>
                                            <option value="follow_up"
                                                {{ $communication->type == 'follow_up' ? 'selected' : '' }}>follow up
                                            </option>
                                            <option value="site" {{ $communication->type == 'site' ? 'selected' : '' }}>
                                                site
                                            </option>
                                            <option value="visit" {{ $communication->type == 'visit' ? 'selected' : '' }}>
                                                Visit
                                            </option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="state">State: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="state" class="select2 custom-select form-control-border"
                                            id="state">
                                            <option value="todo" {{ $communication->state == 'todo' ? 'selected' : '' }}>
                                                to do</option>
                                            <option value="in_progress"
                                                {{ $communication->state == 'in_progress' ? 'selected' : '' }}>in
                                                progress
                                            </option>
                                            <option value="done" {{ $communication->state == 'done' ? 'selected' : '' }}>
                                                done</option>
                                            <option value="cancel"
                                                {{ $communication->state == 'cancel' ? 'selected' : '' }}>cancel
                                            </option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="broker">broker: </label>
                                    </td>
                                    <td class="form-group">
                                        <input type="hidden" name="broker_id" value="{{ $broker?->id }}">
                                        <select name="broker_id" disabled class="custom-select form-control-border"
                                            id="broker">
                                            <option value="{{ $broker?->id }}">
                                                {{ $broker?->name }}
                                            </option>
                                        </select>
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <label for="agents">Agents: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="agent_id" class="select2 custom-select form-control-border"
                                            id="agents">
                                            @foreach ($agents as $agent)
                                                <option value="{{ $agent->id }}"
                                                    {{ $communication->agent_id == $agent->id ? 'selected' : '' }}>
                                                    {{ $agent->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <label for="start">To Do: </label>
                                    </td>
                                    <td class="form-group">
                                        <input type="datetime-local" class="form-control" id="start"
                                            value="{{ date('Y-m-d H:i:s') }}" name="start_date"
                                            min="{{ date('Y-m-d H:i:s') }}"
                                            value="{{ $communication->event->start ?? '' }}">
                                    </td>
                                </tr>
                                <tr id="reminderInput">
                                    <td>
                                        <label for="reminder">Reminder: </label>
                                    </td>
                                    <td class="form-group">
                                        <input type="datetime-local" class="form-control" id="reminder" name="reminder"
                                            min="{{ date('Y-m-d H:i:s') }}" value="{{ $communication->reminder ?? '' }}">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="description">Description: </label>
                                    </td>
                                    <td class="form-group">
                                        <textarea type="text" class="form-control" rows="8" cols="30" name="description" id="description">
                                            {{ $communication->description ?? '' }}
                                        </textarea>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-info" style="margin-left:45%">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- CheckIn --}}
    <div class="modal fade" id="CheckIn" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Activity CheckIn</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form action="{{ route('checkIn') }}" method="POST">

                    <div class="modal-body">
                        @csrf
                        {{-- @method('PUT') --}}
                        <input type="hidden" value="{{ $communication->id }}" name="communication_id">
                        <table>
                            <tbody>

                                <tr>
                                    <td>
                                        <label for="start">To Do: </label>
                                    </td>
                                    <td class="form-group">
                                        <input type="datetime-local" class="form-control" id="start"
                                            name="start_date" value="{{ $communication->event->start ?? '' }}">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="end">Close : </label>
                                    </td>
                                    <td class="form-group">
                                        <input type="datetime-local" class="form-control" id="end" name="end_date"
                                            value="{{ $communication->event->end ?? '' }}">
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <label for="description">Description: </label>
                                    </td>
                                    <td class="form-group">
                                        <textarea type="text" class="form-control" rows="8" cols="30" name="description" id="description">
                                            {{ $communication->description ?? '' }}
                                        </textarea>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Check in</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- Re-Assign User --}}
    <div class="modal fade" id="reAssignUser" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Re-Assign User</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form action="{{ route('activityReAssign') }}" method="POST">

                    <div class="modal-body">
                        @csrf
                        {{-- @method('PUT') --}}
                        <input type="hidden" value="{{ $communication->id }}" name="communication_id">
                        <select name="user_id" class="select2 custom-select form-control-border" id="type">
                            @foreach ($users as $user)
                                <option value="{{ $user->id }}">{{ $user->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-info">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- <div class="modal fade" id="changeStatus" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Change Status</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form action="{{ route('communications.changeStatus', $communication->id) }}" method="POST">

                    <div class="modal-body">
                        @csrf
                        <select name="state" class="select2 custom-select form-control-border" id="type">
                            <option>planning</option>
                            <option>done</option>
                        </select>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-info">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div> --}}
@endsection
