@extends ('../welcome')

@section('content')
    <!-- Main content -->
    @if(auth()->user()->hasRole("SuperAdmin") || auth()->user()->hasRole("Sales Director") || auth()->user()->hasRole("Sales Manager") || auth()->user()->hasRole("Sales Team Leader")
    || auth()->user()->hasRole("Sales Admin") || auth()->user()->hasRole("Sales Agent"))
    {{-- <div class="row">
        <div class="dropdown col-6">
            <button class="btn btn-info dropdown-toggle" type="button" data-toggle="dropdown">
                Reports
                <span class="caret"></span></button>
            <ul class="dropdown-menu">
                <li class="p-3"><a class="text-info" data-target="#DailyCrmReport" data-toggle="modal" href="#">Sales
                        Report</a>
                </li>
                <li class="p-3"><a class="text-info" data-target="#DailySalesReport" data-toggle="modal"
                        href="#">Daily
                        CRM Active
                        Call Report</a></li>
                <li class="p-3"><a class="text-info" data-target="#SalesReport" data-toggle="modal" href="#">Main
                        Sales Report</a>
                </li>
                <li class="p-3"><a class="text-info" data-target="#projectsReport" data-toggle="modal"
                        href="#">Projects Report</a>
                </li>
                <li class="p-3"><a class="text-info" data-target="#cilReport" data-toggle="modal"
                    href="#">Cil Report</a>
            </li>
            </ul>
        </div>
    </div> --}}
    
    <div class="row">
        <div class="col-12">
            <div class="card ">
                <div class="card-title p-2" style="background-color: #17a2b8; color:white">
                    <h3>DAILY REPORT </h3>
                </div>
                <div class="card-body" style="border: 2px solid #17a2b8;">
                    <div class="row">
                        @foreach ($statuses as $statuse)
                            <div class="col-3 p-3 mx-1 shadow border" style="flex: 0 0 24%;">
                                <h1 id="counter-{{ $statuse->id }}">0
                                </h1>
                                <p id="currentValue-{{ $statuse->id }}" class="d-none">
                                    @php
                                        $leadsCount = 0;
                                        foreach ($leadsDaily as $lead) {
                                            if ($lead->status_id == $statuse->id) {
                                                $leadsCount++;
                                            }
                                        }
                                        echo $leadsCount;
                                    @endphp</p>
                                <h5> {{ $statuse->name }}</h5>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card ">
                <div class="card-title p-2" style="background-color: #17a2b8; color:white">
                    <h3>Monthly REPORT </h3>
                </div>
                <div class="card-body" style="border: 2px solid #17a2b8;">
                    <div class="row">
                        @foreach ($statuses as $statuse)
                            <div class="col-3 p-3 mx-1 shadow border" style="flex: 0 0 24%;">
                                <h1 id="counter-{{ $statuse->name }}">0
                                </h1>
                                <p id="currentValue-{{ $statuse->name }}" class="d-none">
                                    @php
                                        $leadsCount = 0;
                                        foreach ($leadsMonthly as $lead) {
                                            if ($lead->status_id == $statuse->id) {
                                                $leadsCount++;
                                            }
                                        }
                                        echo $leadsCount;
                                    @endphp
                                </p>
                                <h5> {{ $statuse->name }}</h5>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
    {{-- //////////////////////////////////// REPORT Modal ///////////////////////////// --}}
    <form action="{{ route('DailyCrmReport') }}" method="POST" enctype="multipart/form-data">
        <div class="modal fade" id="DailyCrmReport" tabindex="-1" role="dialog" aria-labelledby="DailyCrmReport"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Daily CRM Report</h5>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <div class="row">
                                <label class="col-6">From</label>
                                <label class="col-6">to</label>
                            </div>
                            <div class="form-group row">
                                <input type="date" name="start_date" class="form-control col-6">
                                <input type="date" name="end_date" class="form-control col-6">
                            </div>
                        </div>
                    </div>
                    @csrf
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-info yes" type="button">import</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <form action="{{ route('DailySalesReport') }}" method="POST" enctype="multipart/form-data">
        <div class="modal fade" id="DailySalesReport" tabindex="-1" role="dialog" aria-labelledby="DailySalesReport"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Daily CRM Active Call Report</h5>
                    </div>
                    <div class="modal-body">
                    </div>
                    @csrf
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-info yes" type="button">import</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <form action="{{ route('DailySalesReport') }}" method="POST" enctype="multipart/form-data">
        <div class="modal fade" id="SalesReport" tabindex="-1" role="dialog" aria-labelledby="SalesReport"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Sales Report</h5>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <div class="row">
                                <label class="col-6">From</label>
                                <label class="col-6">to</label>
                            </div>
                            <div class="form-group row">
                                <input type="date" name="start_date" class="form-control col-6">
                                <input type="date" name="end_date" class="form-control col-6">
                            </div>
                        </div>
                    </div>
                    @csrf
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-info yes" type="button">import</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <form action="{{ route('projectsReport') }}" method="POST" enctype="multipart/form-data">
        <div class="modal fade" id="projectsReport" tabindex="-1" role="dialog" aria-labelledby="projectsReport"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Projects Report</h5>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <div class="row">
                                <label class="col-6">From</label>
                                <label class="col-6">to</label>
                            </div>
                            <div class="form-group row">
                                <input type="date" name="start_date" class="form-control col-6">
                                <input type="date" name="end_date" class="form-control col-6">
                            </div>
                        </div>
                    </div>
                    @csrf
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-info yes" type="button">import</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <form action="{{ route('cilReport') }}" method="POST" enctype="multipart/form-data">
        <div class="modal fade" id="cilReport" tabindex="-1" role="dialog" aria-labelledby="cilReport"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Cil Report</h5>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <div class="row">
                                <label class="col-6">From</label>
                                <label class="col-6">to</label>
                            </div>
                            <div class="form-group row">
                                <input type="date" name="start_date" class="form-control col-6">
                                <input type="date" name="end_date" class="form-control col-6">
                            </div>
                        </div>
                    </div>
                    @csrf
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-info yes" type="button">import</button>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <!-- /.content -->
    <script>
        @foreach ($statuses as $statuse)
            var counterElement{{ $statuse->id }} = document.getElementById('counter-{{ $statuse->id }}');
            var currentValueElement{{ $statuse->id }} = document.getElementById('currentValue-{{ $statuse->id }}');
            var counterValue{{ $statuse->id }} = 0;
            var currentValue{{ $statuse->id }} = parseInt(currentValueElement{{ $statuse->id }}.textContent);

            var counterInterval{{ $statuse->id }} = setInterval(function() {
                if (counterValue{{ $statuse->id }} < currentValue{{ $statuse->id }}) {
                    counterValue{{ $statuse->id }}++;
                    counterElement{{ $statuse->id }}.textContent = counterValue{{ $statuse->id }}.toString();
                } else {
                    clearInterval(counterInterval{{ $statuse->id }});
                }
            }, 150);
        @endforeach

        function monthlyCount() {
            @foreach ($statuses as $statuse)
                var counterElement{{ $statuse->id }} = document.getElementById('counter-{{ $statuse->name }}');
                var currentValueElement{{ $statuse->id }} = document.getElementById(
                    'currentValue-{{ $statuse->name }}');
                var counterValue{{ $statuse->id }} = 0;
                var currentValue{{ $statuse->id }} = parseInt(currentValueElement{{ $statuse->id }}.textContent);

                var counterInterval{{ $statuse->id }} = setInterval(function() {
                    if (counterValue{{ $statuse->id }} < currentValue{{ $statuse->id }}) {
                        counterValue{{ $statuse->id }}++;
                        counterElement{{ $statuse->id }}.textContent = counterValue{{ $statuse->id }}
                            .toString();
                    } else {
                        clearInterval(counterInterval{{ $statuse->id }});
                    }
                }, 150);
            @endforeach
        }

        monthlyCount();
    </script>
@endsection
