@extends ('../welcome')


@section ('content')

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">

                <div class="timeline-item">
                    <h8 class="timeline-header no-border"> <span style="font-weight: bold;">Client ID:</span>
                        {{$client->id}}
                    </h8><br>
                    <h8 class="timeline-header no-border"><span style="font-weight: bold;">Client Name:</span>
                        {{$client->name}}
                    </h8><br>
                    <h8 class="timeline-header no-border"><span style="font-weight: bold;">Payment Method:</span>
                        {{$client->payment_method}}
                    </h8><br>
                    <h8 class="timeline-header no-border"><span style="font-weight: bold;">Payment Details:</span>
                        {{$client->payment_details}}
                    </h8><br>
                    <hr>
                    <h8 class="timeline-header no-border"><span style="font-weight: bold;">Payment Title:</span>
                        {{$payment->title}}
                    </h8><br>
                    <h8 class="timeline-header no-border"><span style="font-weight: bold;">Total Amount:</span>
                        {{$payment->total_amount}}
                    </h8><br>
                    <h8 class="timeline-header no-border"><span style="font-weight: bold;">Total Paid:</span>
                        {{$payment->total_paid}}
                    </h8><br>
                    <h8 class="timeline-header no-border"><span style="font-weight: bold;">Payment Status:</span>
                        {{$payment->status}}
                    </h8><br>
                    <h8 class="timeline-header no-border"><span style="font-weight: bold;">Payment Date:</span>
                        {{$payment->created_at}}
                    </h8><br>


                </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body table-responsive p-0" style="height: 300px;">
                <table class="table table-head-fixed text-nowrap">
                    <thead>
                        <tr style="text-align: center">
                            <th>Transaction ID</th>
                            <th>Amount</th>
                            <th>Created at</th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach($transactions as $transaction)
                        <tr style="text-align: center">
                            <td>
                                {{$transaction->id}}
                            </td>

                            <td>{{$transaction->amount}}</td>
                            <td>{{$transaction->created_at}}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>
</div>
<!-- /.row -->

@endsection