@extends ('../welcome')


@section('content')



<div class="card card-default">

    <form action="{{route('paymentPlans.store')}}" method="post">
        @csrf

        <div class="card-body">
            <div class="row">
                <div class="form-group">
                    <label>Title</label>
                    <input type="text" id="title" name="title" class="form-control" placeholder="Title" required>
                </div>
                <div class="form-group" style="display:none">
                    <!-- <label>% or Value</label>  -->
                    <select name="c_method" class="custom-select">
                        <option value="percentage">%</option>
                        {{--<option value="value">value</option>--}}
                    </select>
                </div>
                <div class="form-group">
                    <label>Total Years</label>
                    <input name="total_years" id="total_years" class="form-control" type="number" placeholder=""
                        required>
                </div>
                <div class="form-group">
                    <label>Type</label>
                    <select name="type" placeholder="Type" class="select2 custom-select form-control-border">
                        <!-- <option value="DownPayment">Down Payment</option> -->
                        <option value="total_unit">Total Unit</option>
                        <option value="maintenance">Maintenance</option>
                    </select>
                </div>
                <button id="addRow" title="add Type" type="button" class="btn btn-info"
                    style="margin-left: 20px; margin-top:32px;width:20%px;height:20%;">
                    <i class="fas fa-plus"></i>
                </button>
            </div>
            <div id="inputFormRow">
                <div class="row">
                    <div class="form-group col-2">
                        <input name="payment_type_id[]" type="hidden" value="{{$paymentTypes[0]['id']}}">
                        <input type="text" class="form-control" value="{{$paymentTypes[0]['name']}}" readonly>
                    </div>

                    <div class="form-group col-2">
                        <input type="number" name="amount[]" placeholder="amount" class="form-control" placeholder="00"
                            required>
                    </div>
                    <div class="form-group col-2">
                        <input type="number" name="batch[]" placeholder="batch" class="form-control" value="1" required
                            readonly>
                    </div>
                </div>

                <div class="row">
                    <div class="form-group col-2">
                        <select  name="payment_type_id[]" placeholder="Payment Type"
                            class="custom-select form-control" id="paymentType">
                            <option></option>
                            @foreach($paymentTypes as $type)
                            @if($type->id != 1)
                            <option value="{{$type->id}}">{{$type->name}}</option>
                            @endif
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group col-2">
                        <input type="number" name="amount[]" placeholder="amount" class="form-control" placeholder="00"
                            required>
                    </div>
                    <div class="form-group col-2">
                        <input type="number" name="batch[]" placeholder="batch" class="form-control " placeholder="00"
                            required>
                    </div>
                </div>

                <div id="newRow"></div>
            </div>
            <div class="col-10" style="display:flex;justify-content:center;">
                <button type="submit" class="btn btn-info" style="width: 33%; margin-top:20px;">Submit</button>
            </div>
        </div>
    </form>
</div>

<script src="{{asset('asset/plugins/jquery/jquery.min.js')}}"></script>
<script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
<script type="text/javascript">
// add row
$("#addRow").click(function() {
    var html = '';
    html += `
    <div id="inputFormRow" class="inputFormRow">
        <div class="row">
            <div class="form-group col-2">
                <select id="payment_type" name="payment_type_id[]" class="select2 custom-select form-control-border payment_type">
                <option></option>
                    @foreach($paymentTypes as $type)
                    @if($type->id != 1)
                    <option value="{{$type->id}}">{{$type->name}}</option>
                    @endif
                    @endforeach
                </select>
            </div>

            <div class="form-group col-2">
                <input type="number" name="amount[]" class="form-control" placeholder="amount" required>
            </div>
            <div class="form-group col-2">
                <input type="number" id="batches" name="batch[]" class="form-control batches" placeholder="batch" required>
            </div>
            
            <div class="col-1">
                <button id="removeRow" type="button" class="btn btn-danger">
                    <i class="fas fa-trash-alt"></i>
                </button>
            </div>
        </div>
    </div>`;

    $('#newRow').append(html);
});

// remove row
$(document).on('click', '#removeRow', function() {
    $(this).closest('#inputFormRow').remove();
});

let total_years = document.getElementById('total_years');

let total_year;
let months;
let batchesValue;
let batches = 0;

total_years.addEventListener('input', () => {
    total_year = total_years.value;
    months = total_year * 12;
})

let addRow = document.getElementById('addRow')

addRow.addEventListener('click', () => {
    let payment_type = document.querySelectorAll('.payment_type');
    payment_type.forEach(e => {
        e.addEventListener('change', (target) => {
            let target_value = target.target.value;
            if (target_value == 2) {
                batches = months;
            } else if (target_value == 3) {
                batches = months / 3;
            } else if (target_value == 4) {
                batches = total_year;
            } else {
                batches = 0;
            }
            const element = target.target;
            const element_id = element.id;
            let test = document.getElementById(element.id);
            batchesValue = element.closest(".row").childNodes[5].getElementsByTagName('input');
            batchesValue[0].value = batches;
        })
    })
});

let paymentType = document.getElementById('paymentType');
paymentType.addEventListener('change', () => {
    if(paymentType.value == 2) {
        batches = months;
    }else if(paymentType.value == 3) {
        batches = months / 3;
    }else if(paymentType.value == 4) {
        batches = total_year;
    }else{
        batches = 0;
    }
    
    batches1stValue = paymentType.closest(".row").getElementsByTagName('input');
    batches1stValue[1].value = batches;
})



</script>
@endsection