@extends ('../welcome')
@section('content')


<div class="card">
    <div class="card-header">
        <a href="{{route('paymentPlans.create')}}" style="float:right" class="btn btn-light"><i
                class="fas fa-plus"></i></a>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <table id="example1" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Title</th>
                    <th>C_Method</th>
                    <th>type</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($paymentPlans as $plan)
                <?php $temp = explode(' ',$plan->created_at->setTimezone('Africa/Cairo'));?>

                <tr>
                    <td>{{ $plan->id }}</td>
                    <td>
                        {{ $plan->name }}

                    </td>
                    <td>
                        {{ $plan->c_method == 'percentage'? '%' : 'value' }}
                    </td>
                    <td>
                        {{ $plan->type == 'total_unit' ? 'Total Unit' : 'Maintenance' }}
                    </td>
                    <!-- <td>{{$temp[0]}}</td>
                    <td>{{$temp[1]}}</td> -->
                    <td>
                        <a class="btn btn-warning" title="show" href="{{ route('paymentPlans.show',$plan->id) }}">
                            <i class="fa fa-eye"></i>
                        </a>
                        @if(count($plan->projects) == 0)

                        <a class="btn btn-info" title="Edit" href="{{ route('paymentPlans.edit',$plan->id) }}">
                            <i class="fa fa-pen"></i>
                        </a>
                        <!-- <button onClick="clickDeletebutton(this)" title="Delete" class="btn btn-danger"
                            data-id="{{$plan->id}}" data-toggle="modal" data-target="#exampleModalCenter">
                            <i class="fa fa-ban"></i>
                        </button> -->
                        @endif

                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>

    </div>
</div>
<div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Delete Record</h5>
            </div>
            <div class="modal-body">
                <p>Are you sure to delete this record ?</p>
            </div>
            <form class="modal-footer" method="post">
                @csrf
                @method('DELETE')
                <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
            </form>
        </div>
    </div>
</div>



<!-- /.row -->
<script>
clickDeletebutton = (e) => {
    const modelId = e.getAttribute("data-id");
    var route = "{{route('paymentPlans.destroy',':id')}}";
    route = route.replace(':id', modelId);
    $('#exampleModalCenter').find($('form')).attr('action', route);
}
</script>

@endsection