@extends ('../welcome')
@section('content')
<style>
    html {
        width:1900px;
    }
</style>
@if(count($paymentPlan->projects) == 0)
<div class="card-header">
<a href="{{route('paymentPlans.edit', $paymentPlan->id)}}" style="float:center" class="btn btn-info"><i class="fas fa-pen"> &nbsp Update Plan</i></a>
</div>
@endif
<div class="card-body">
    <div class=" row">
        <label class="col-sm-3 col-form-label">Title :</label>
        <label class="col-sm-4 col-form-label">{{ $paymentPlan->name }} </label>
    </div>

    <div class=" row">
        <label class="col-sm-3 col-form-label">Calculation Method :</label>
        <label class="col-sm-4 col-form-label">{{ $paymentPlan->c_method == 'percentage' ? '%' : 'Value'}}</label>
    </div>

    <div class=" row">
        <label class="col-sm-3 col-form-label">Type :</label>
        <label class="col-sm-4 col-form-label">{{ $paymentPlan->type == 'total_unit' ? 'Total Amount' : 'Maintenance' }} </label>
    </div>
    <div class=" row">
        <label class="col-sm-3 col-form-label">Created at :</label>
        <label class="col-sm-4 col-form-label">{{ $paymentPlan->created_at }} </label>
    </div>
</div>
<br>

<div class="col-12">
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Payment of ({{$paymentPlan->name}}) plan Details</h3>
        </div>
        <!-- /.card-header -->
        <div class="card-body">
        <table id="example1" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>amount</th>
                        <th>batches</th>
                        <th>count</th>
                        <th>payment_type</th>
                        <th>Created Date</th>
                        <th>Created Time</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($paymentPlan->PaymentPlanDetails as $details)
                    <?php $temp = explode(' ',$details->created_at->setTimezone('Africa/Cairo'));?>

                    <tr>
                        <td>{{ $details->id ?? ''}}</td>
                        <td>{{ $paymentPlan->c_method == 'percentage' ?  $details->amount.'%' : ''}}</td>
                        <td>{{ $details->batch ?? ''}}</td>
                        <td>{{ $details->count ?? ''}}</td>

                        <td>
                            {{ $details->PaymentType->name ?? '' }}
                        </td>
                        <td>{{$temp[0]}}</td>
                        <td>{{$temp[1]}}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
    </div>
</div>
<div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Delete Record</h5>
            </div>
            <div class="modal-body">
                <p>Are you sure to delete this record ?</p>
            </div>
            <form class="modal-footer" method="post">
                @csrf
                @method('DELETE')
                <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
            </form>
        </div>
    </div>
</div>



<!-- /.row -->
<script>
$(function() {
    $("#phases").DataTable({
        "responsive": true,
        "lengthChange": false,
        "autoWidth": false,
        "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#phases_wrapper .col-md-6:eq(0)');
    $('#example2').DataTable({
        "paging": true,
        "lengthChange": false,
        "searching": false,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "responsive": true,
    });
});

clickDeletebutton = (e) => {
    const modelId = e.getAttribute("data-id");
    var route = "{{route('buildings.destroy',':id')}}";
    route = route.replace(':id', modelId);
    $('#exampleModalCenter').find($('form')).attr('action', route);
}
</script>

@endsection