@extends ('../welcome')


@section('content')
    <div class="card card-info col-6">

        <!-- /.card-header -->
        <div class="card-body">
            <form action="{{ route('phases.store') }}" method="post">
                @csrf

                <div class="form-group row">
                    <label class="col-2">Name</label>
                    <input type="text" name="name" class="form-control col-8" placeholder="Phase Name">
                </div>
                @if ($project->is_residential == 0)
                    <div class="form-group row">
                        <label class="col-2">Type:</label>
                        <select name="type" class="select2 custom-select form-control-border access_type col-4">
                            <option value="administrative">Administrative</option>
                            <option value="medical">Medical</option>
                            <option value="commercial">Commercial</option>
                        </select>
                    </div>
                @endif
                <div class="form-group row">
                    <label class="col-2">Users:</label>
                    <select name="user_id[]" class="select2 custom-select form-control-border col-8" multiple>
                        @foreach ($users as $user)
                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                        @endforeach
                    </select>
                </div>
                <input name="is_active" value="1" type="hidden">
                <input type="hidden" name="project_id" value="{{ $project->id }}">

                <button type="submit" style="float:right" class="btn btn-info">Submit</button>
            </form>
        </div>
        <!-- /.card-body -->
    </div>
@endsection
