@extends ('../welcome')

@section('content')
    {{-- Filter --}}
    <div class="card card-info card-outline collapsed-card col-12">
        <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
            <div class="card-title">
                Filter
            </div>
        </div>
        <div class="card-body">
            <form>
                <div class="row">
                    <div class="col-6">
                        <div class="form-group">
                            <label>phases</label>

                            <select name="phase_id[]" class="select2 custom-select form-control-border" multiple>
                                @foreach ($phases as $phase)
                                    <option value="{{ $phase->id }}">{{ $phase->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label>Projects</label>

                            <select name="project_id[]" class="select2 custom-select form-control-border" multiple>
                                @foreach ($projects as $project)
                                    <option value="{{ $project->id }}">{{ $project->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-6">
                        <div class="row">
                            <div class="form-group col-6">
                                <label>From</label>
                                <input type="time" value="{{ $_GET['time1'] ?? '' }}" class="form-control"
                                    name="time1">
                            </div>
                            <div class="form-group col-6">
                                <label>to</label>

                                <input type="time" name="time2" value="{{ $_GET['time2'] ?? '' }}"
                                    class="form-control">
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-6">
                                <input type="date" name="date1" value="{{ $_GET['date1'] ?? '' }}"
                                    class="form-control">
                            </div>
                            <div class="form-group col-6">
                                <input type="date" name="date2" value="{{ $_GET['date2'] ?? '' }}"
                                    class="form-control">
                            </div>
                        </div>

                        <a href="{{ url()->previous() }}" class="btn btn-default">Back</a>
                        <button type="submit" class="btn btn-info" style="float:left">filter</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    {{-- Fnd Filter --}}
    
    <!-- Phases -->
    <!-- /.row -->
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Phases</h3><br>
                <p>Total: {{ $phases->total() }}</p>

                <div style="float:right">
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('phases-export'))
                        <a href="{{ route('phases.export', request()->query()) }}" class="btn btn-outline-primary" title="Export to Excel">
                            <i class="fas fa-file-excel"></i> Export
                        </a>
                    @endif
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('phases-archive'))
                        <a href="{{ route('phasesArchive') }}" style="margin-left: 5px;">
                            <button class="btn btn-outline-success" title="Archive" type="button"><i
                                    class="fas fa-archive"></i></button>
                        </a>
                    @endif
                </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <table
                    id={{ auth()->user()->type == 'admin' ||auth()->user()->role->hasPermission('phases-export')? 'example1': 'nonExport' }}
                    class="table table-bordered" style="margin: unset">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Phase Name</th>
                            <th>Project Name</th>
                            <th>Created Date</th>
                            <th>Created Time</th>

                            @if (auth()->user()->type == 'admin')
                                <th>Active</th>
                            @endif
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($phases as $phase)
                            <?php $temp = explode(' ', $phase->created_at->setTimezone('Africa/Cairo')); ?>

                            @if (!empty($phase->project->id))
                                <tr>
                                    <td>{{ $phase->id }}</td>
                                    <td>
                                        @if (auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('phases-show'))
                                            <a href="{{ route('phases.show', $phase->id) }}">
                                                {{ $phase->name }}
                                            </a>
                                        @else
                                            <a>
                                                {{ $phase->name }}
                                            </a>
                                        @endif
                                    </td>
                                    <td>
                                        @if (auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('projects-show'))
                                            <a href="{{ route('projects.show', $phase->project->id) }}">
                                                {{ $phase->project->name }}
                                            </a>
                                        @else
                                            <a>
                                                {{ $phase->project->name }}
                                            </a>
                                        @endif
                                    </td>
                                    <td>{{ $temp[0] }}</td>
                                    <td>{{ $temp[1] }}</td>
                                    <td>
                                        @if (auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('phases-hide'))
                                            <form action="{{ route('hidePhase', $phase->id) }}" method="POST">
                                                @csrf
                                                <button type="submit"
                                                    class="btn btn-{{ $phase->is_active == 0 ? 'info' : 'danger' }}"
                                                    title="{{ $phase->is_active == 0 ? 'unhide' : 'hide' }}">
                                                    {{ $phase->is_active == 0 ? 'unhide' : 'hide' }}
                                                </button>
                                            </form>
                                        @endif
                                    </td>

                                </tr>
                            @endif
                        @endforeach
                    </tbody>
                </table>
                <div class="pagination">
                    {{ $phases->appends(request()->input())->links() }}
                </div>

            </div>
            <!-- /.card-body -->
        </div>
    </div>
    <!-- /.row -->
@endsection
