@extends ('../welcome')
@section('content')
<div class="row">
    <div class="col-3"></div>
    <div class="card col-4" style="margin-top:150px;margin-left:60px;">
        <div class="card-header">
            Edit phone number 
        </div>
        <form action="{{ route('phones.update', $phone->id) }}" method="post">
            @csrf
            @method('PUT')
            <div class="card-body">
                @if($client != NULL)
                <div class="form-group">
                    <input class="form-control" name="client_id" type="hidden" value="{{ $client?->id }}">
                </div>
                @endif
                <div class="row">
                    <div class="form-group col-4">
                        <select class="form-control" name="country_id" required>
                            <option></option>
                            @foreach($codes as $code)
                            <option value="{{ $code->id }}" {{ $code->id == $phone->country_id ? 'selected' : '' }}>
                                {{ $code->name }} +{{ $code->phonecode }}
                            </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-8">
                        <input class="form-control" name="phone" type="text" value="{{ $phone->phone }}" required>
                        <div id="phone-error" style="display:none;"></div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <a class="btn btn-light" href="{{ url()->previous() }}">Back</a>
                <button type="submit" class="btn btn-info">submit</button>
            </div>
        </form>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
jQuery(document).ready(function($) {
    // Remove leading zeros from phone number input
    $(document).on('input', 'input[name="phone"]', function() {
        var phoneNumber = $(this).val();
        if (phoneNumber.length > 1 && phoneNumber.startsWith('0')) {
            $(this).val(phoneNumber.replace(/^0+/, ''));
        }
    });
    $(document).on('blur', 'input[name="phone"]', function() {
        var phoneNumber = $(this).val();
        if (phoneNumber.length > 1 && phoneNumber.startsWith('0')) {
            $(this).val(phoneNumber.replace(/^0+/, ''));
        }
    });
    // Phone duplication check for phone edit (excluding current phone)
    $(document).on('input', 'input[name="phone"]', function() {
        var phoneNumber = $(this).val();
        var countrySelect = $(this).closest('.row').find('select[name="country_id"]');
        var selectedCountryCode = countrySelect.find('option:selected').text().split('+').pop().trim();
        var errorDiv = $('#phone-error');
        var currentPhoneId = {{ $phone->id }};
        if (phoneNumber.length > 3) {
            $.ajax({
                url: '{{ route('check-phone-except-current') }}',
                type: 'POST',
                data: {
                    phone: phoneNumber,
                    country_code: selectedCountryCode,
                    current_phone_id: currentPhoneId,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    if (response.exists) {
                        errorDiv.text('This Phone Number is Duplicated').show()
                            .removeClass('valid-feedback').addClass('invalid-feedback');
                    } else {
                        errorDiv.text('Phone Number is available').show().removeClass(
                            'invalid-feedback').addClass('valid-feedback');
                    }
                },
                error: function() {
                    errorDiv.text('Error occurred while checking the phone number')
                        .show().removeClass('valid-feedback').addClass(
                            'invalid-feedback');
                }
            });
        } else {
            errorDiv.hide();
        }
    });
});
</script>
@endsection
