@extends ('../welcome')


@section('content')
    <form action="{{ route('projects.update', $project->id) }}" method="POST" enctype="multipart/form-data">
        <div class="row">
            <div class="card card-info col-6">
                <div class="card-header">
                    <h3 class="card-title">Edit Project</h3>
                </div>
                <!-- /.card-header -->
                <div class="card-body">

                    @csrf
                    @method('PUT')

                    <!-- text input -->
                    <div class="form-group">
                        <label>Name</label>
                        <input type="text" name="name" class="form-control" value="{{ $project->name }}" required>
                    </div>

                    <!-- textarea -->
                    <div class="form-group">
                        <label>Description</label>
                        <textarea class="form-control" name="description" rows="3" required>{{ $project->description }}</textarea>
                    </div>
                    <div class="form-group">
                        <label>Mentainance %</label>
                        <input type="number" step="any" name="mentainance" value="{{ $project->mentainance ?? '' }}"
                            class="form-control" placeholder="00" required>
                    </div>
                    <div class="form-group">
                        <label>project Accessible</label>
                        <select class="select2 custom-select form-control-border access_type">
                            <option value="">Select Type</option>
                            <option value="users">Per User</option>
                            <option value="roles">Per Role</option>
                        </select>
                    </div>
                    <div class="form-group users" style="display: none;">
                        <label>Select Users</label>
                        <select name="user_id[]" class="select2 custom-select form-control-border access_type" multiple>
                            @foreach ($users as $user)
                                <option {{ in_array($user->id, old('user_id', $projectUsers)) ? 'selected' : '' }}
                                    value="{{ $user->id }}">{{ $user->name }}</option>
                            @endforeach

                        </select>
                    </div>
                    <div class="form-group roles" style="display: none;">
                        <label>Select Roles</label>
                        <select name="role_id[]" class="select2 custom-select form-control-border" multiple>
                            @foreach ($roles as $role)
                                <option {{ in_array($role->id, old('role_id', $projectRoles)) ? 'selected' : '' }}
                                    value="{{ $role->id }}">{{ $role->name }}</option>
                            @endforeach

                        </select>
                    </div>

                    <!-- <div id="actions" class="row"> -->
                    <div class="custom-file">
                        <label for="customFile">Upload Logo</label>
                        <input type="file" id="customFile" name="image" accept="image/png, image/jpeg">
                    </div>
                    <div class="row">
                        <div class="col-sm-6">
                            <!-- checkbox -->
                            <div class="form-group">
                                <div class="form-check">
                                    <input class="form-check-input" name="is_residential" value="1" type="checkbox"
                                        {{ $project->is_residential == 1 ? 'checked' : '' }}>
                                    <label class="form-check-label">Residential ?</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <label>Facilities</label>
                    @foreach ($facilities as $facility)
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input class="form-check-input" name="facility_id[]" value="{{ $facility->id }}"
                                            {{ in_array($facility->id, $projectFacilities) ? 'checked' : '' }}
                                            type="checkbox">
                                        <label class="form-check-label">{{ $facility->name }}</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                    &nbsp&nbsp
                    <button type="submit" class="btn btn-primary col start">
                        <span>Submit</span>
                    </button>
                </div>
            </div>
            <!-- Payment Plans -->
            {{-- <div class="col-6">
            <div class="card card-danger">
                <div class="card-header">
                    <h3 class="card-title">Payment Plans</h3>
                </div>
                <div class="card-body">

                    <div class="row">
                        <div class="form-group col-5">
                            <label>Total Unit</label>
                            <select name="tu_payment_plan_id" class="select2 custom-select form-control-border"
                                required>
                                @foreach ($total_unit as $plan)
                                <option value="{{ $plan->id }}">{{ $plan->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group col-5">
                            <label>Maintenance</label>
                            <select name="m_payment_plan_id" class="select2 custom-select form-control-border" required>
                                @foreach ($maintenance as $plan)
                                <option value="{{ $plan->id }}">{{ $plan->name }}</option>
                                @endforeach
                            </select>
                        </div>

                    </div>
                </div>
            </div>
        </div> --}}
        </div>
        <!-- /.card-body -->
        </div>
        </div>
    </form>



    {{-- Payment Plan Section --}}
    {{-- 
    
    <div class="card collapsed-card card-outline col-12">
                        <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                            <h3 class="card-title" style="font-weight:bold;">
                                Payment Plans (Current)
                            </h3>

                        </div>
                        @if (auth()->user()->type == 'admin' ||
    auth()->user()->role->hasPermission('projects-paymentPlan')) 
<div class="card-body">
    @foreach ($project->PaymentPlans()->where('is_active', 1)->get() as $plan)
        <h4>
            <a href="{{ route('paymentPlans.show', $plan->id) }}">{{ $plan->type == 'total_unit' ? 'Total Unit' : 'Maitenance' }}
                - {{ $plan->name }}</a> :
        </h4>
        @foreach ($plan->PaymentPlanDetails as $details)
            <ul>
                <li>Payment Type: {{ $details->PaymentType?->name }}</li>
                <li>Amount: {{ $details->amount }}
                    {{ $plan->c_method == 'percentage' ? '%' : '' }}</li>
                <li>Batches: {{ $details->batch }}</li>
                <li>Count: {{ $details->count }}</li>
            </ul>
        @endforeach
    @endforeach
</div>

{{-- 
@endif
</div> --}}
@endsection
