@extends ('../welcome')


@section('content')
    <div class="card col-12">
        <div class="card-header">
            <h4 class="card-title"><strong>Roles</strong></h4>
            <br>
            <lable><span style="font-size:18px;font-weight:bold">Total: </span> {{ count($roles) }}</lable>
            <div style="float:right;">
                @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('roles-create'))
                    <a href="{{ route('roles.create') }}" title="Create Role" class="btn btn-light active"><i
                            class="fa fa-plus"></i></a>
                @endif
                @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('roles-tree'))
                    <a href="{{ route('rolesTree') }}" title="view tree" class="btn btn-success"><i
                            class="fa fa-tree"></i></a>
                @endif
                @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('roles-archive'))
                    <a href="{{ route('Roles_Archive') }}" class="btn btn-danger" title="Archive"><i
                            class="fas fa-archive"></i></a>
                @endif
            </div>
        </div>

        <!-- /.card-header -->
        <div class="card-body">
            <table class="table table-bordered display" id="example1">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Description</th>
                        <th>Belongs to</th>
                        <th style="text-align:center;">Users</th>
                        <th>Created at</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($roles as $role)
                        @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('roles-show'))
                            <tr class='clickable-row' data-href='{{ route('roles.show', $role->id) }}'>
                            @else
                            <tr class=''>
                        @endif
                        <td>{{ $role->id }}</td>
                        <td>
                            {{ $role->display_name }}
                        </td>
                        <td>{{ $role->description }}</td>
                        <td>{{ $role->parent?->name }}</td>
                        <td style="text-align: center;color:red;">{{ count($role->users) }}</td>
                        <td>{{ $role->created_at }}</td>
                        <td>
                            @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('roles-edit'))
                                <a class="btn btn-info" title="Edit" href="{{ route('roles.edit', $role->id) }}">
                                    <i class="fa fa-pen"></i>
                                </a>
                            @endif

                            @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('roles-delete'))
                                @if (count($role->users) == 0)
                                    <button onClick="clickDeletebutton(this)" type="button" title="Delete"
                                        class="btn btn-danger" data-id="{{ $role->id }}" data-toggle="modal"
                                        data-target="#phaseModal">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                @endif
                            @endif
                        </td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <!-- Delete Model -->

    <div class="modal fade" id="phaseModal" tabindex="-1" role="dialog" aria-labelledby="phaseModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                </div>
                <div class="modal-body">
                    <p>Are you sure to delete this record ?</p>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>
    <!-- End delete  -->

    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('roles.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#phaseModal').find($('form')).attr('action', route);
        }
    </script>
@endsection
