@extends ('../welcome')


@section('content')
    <style>
        label {
            color: #19a2b9;
        }
    </style>
    <form>
        <div class="card card-info  collapsed-card">
            <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                <div class="card-title">
                    Filter
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div id="left side" class="col-6">
                        <table id="Other filters" style="width:85%">
                            <tr>
                                <th style="width:25%" title="Ticket Status">Status: </th>
                                <td class="form-group">
                                    <select class="select2 custom-select form-control-border" multiple
                                        name="ticket_status[]">
                                        <option>pending</option>
                                        <option>follow_up</option>
                                        <option>done</option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%" title="Ticket Type">Type: </th>
                                <td class="form-group">
                                    <select class="select2 custom-select form-control-border" multiple
                                        name="ticketType_id[]">
                                        @foreach ($ticketTypes as $type)
                                            <option value="{{ $type->id }}">{{ $type->name }}</option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%">Units: </th>
                                <td class="form-group">
                                    <select class="select2 custom-select form-control-border" multiple name="unit_id[]">
                                        
                                        @foreach ($units as $unit)
                                            <option value="{{ $unit->id }}">{{ $unit->name }}</option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%">Clients: </th>
                                <td class="form-group">
                                    <select class="select2 custom-select form-control-border" multiple name="client_id[]">
                                        
                                        @foreach ($clients as $client)
                                            <option value="{{ $client->id }}">{{ $client->name }}</option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%" title="Ceator User">Creators: </th>
                                <td class="form-group">
                                    <select class="select2 custom-select form-control-border" multiple name="user_id[]">
                                        
                                        @foreach ($users as $user)
                                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                        </table>
                    </div>

                    <div id="right side" class="col-6">
                        <table id="action creation">
                            <tr colispan>
                                <th colspan="4" style="text-align:center">Action Creation</th>
                            </tr>
                            <tr>
                                <th>From</th>
                                <td class="form-group">
                                    <input type="date" name="action_creation1" class="form-control">
                                </td>
                                <th>To</th>
                                <td class="form-group">
                                    <input type="date" name="action_creation2" class="form-control">
                                </td>
                            </tr>
                        </table>
                        <hr>
                        <br>
                        <table id="ticket creation">
                            <tr colispan>
                                <th colspan="4" style="text-align:center">Ticket Creation</th>
                            </tr>
                            <tr>
                                <th>From</th>
                                <td class="form-group">
                                    <input type="date" name="ticket_creation1" class="form-control">
                                </td>
                                <th>To</th>
                                <td class="form-group">
                                    <input type="date" name="ticket_creation2" class="form-control">
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
            <div class="card-footer" style="text-align:right">
                <button type="submit" class="btn btn-info">filter</button>
                <a href="{{ url()->previous() }}" class="btn btn-default">Back</a>
            </div>
        </div>
    </form>
    <div class="card">
        <!-- /.card-header -->
        <div class="card-header">
            <div class="card-title">Actions <br> Total: {{ $actions->total() }}</div>
            <div style="float:right">
                @if (auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('ticket-actions-export'))
                    <a href="{{ route('actions.export', request()->query()) }}" class="btn btn-outline-primary" title="Export to Excel">
                        <i class="fas fa-file-excel"></i> Export
                    </a>
                @endif
            </div>
        </div>
        <div class="card-body">
            <table
                id={{ auth()->user()->type == 'admin' ||auth()->user()->role->hasPermission('ticket-actions-export')? 'example2': 'nonExport' }}
                class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Ticket ID</th>
                        <th>Action Creator</th>
                        <th>Ticket Type</th>
                        <th>Ticket Creation Date</th>
                        <th>Unit</th>
                        <th>Client Name</th>
                        <th>Client Mobile</th>
                        <th>Action</th>
                        <th>Details</th>
                        <th>Assigned User</th>
                        <th>Action created at</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($actions as $action)
                        {{-- @if ($action->event == 'follow_up' || $action->event == 'done' || $action->event == 'Create' || $action->event == 'Assign-User') --}}
                        <?php $action_created_at = explode(' ', $action->created_at->setTimezone('Africa/Cairo')); ?>
                        <?php $ticket_created_at = explode(' ', $action->ticket->created_at->setTimezone('Africa/Cairo')); ?>
                        <tr>
                            <td>
                                <a href="{{ route('tickets.show', $action->ticket_id) }}">
                                {{ $action->ticket_id ?? '' }}
                                </a>
                            </td>
                            <td>
                                <a href="{{ route('users.show', $action->created_by?->id) }}">
                                    {{ $action->created_by?->name ?? '' }}
                                </a>
                            </td>

                            <td>
                                {{ $action->ticket->ticket_type?->name ?? '' }}
                            </td>

                            <td>
                                {{ Carbon\Carbon::parse($action->ticket->created_at)->format('Y-m-d H:i:s') ?? '' }}
                            </td>
                            <td>
                                <a href="{{ route('units.show', $action->unit_id) }}">
                                    {{ $action->unit->name ?? '' }}
                                </a>
                            </td>
                            <td>
                                <a href="{{ route('clients.show', $action->client_id) }}">
                                    {{ $action->client->name ?? '' }}
                                </a>
                            </td>
                            <td>
                                @if($action->client && $action->client->phone_numbers)
                                    @foreach ($action->client->phone_numbers as $phone)
                                        <a href="https://wa.me/{{ $phone->country->phonecode }}{{ $phone->phone }}" target="_blank">
                                            {{ $phone->country->phonecode }} {{ $phone->phone }}
                                        </a>
                                        <br>
                                    @endforeach
                                @else
                                    --
                                @endif
                            </td>
                            <td>
                                {{ $action->action_type ?? '' }}
                            </td>
                            <td>
                                {{ $action->details ?? '' }}
                            </td>
                            <td>
                                <a href="{{ route('users.show', $action->assigned_user_id) }}">
                                    {{ $action->assigned_user_name ?? '' }}
                                </a>
                            </td>
                            <td>
                                {{ Carbon\Carbon::parse($action->created_at)->format('Y-m-d H:i:s') ?? '' }}
                            </td>

                            {{-- <td>{{ $temp[0] }}</td>
                            <td>{{ $temp[1] }}</td> --}}
                        </tr>
                        {{-- @endif --}}
                    @endforeach
                </tbody>
            </table>
            <div class="pagination">
                {{ $actions->links() }}
            </div>
        </div>
        <!-- /.card-body -->
    </div>
@endsection
